@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.GangliaLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams
 */
public data class GangliaLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<GangliaLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.GangliaLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.GangliaLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.GangliaLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GangliaLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class GangliaLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<GangliaLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("vytmguuavruxpwns")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("wfaajbameteucbkf")
    public suspend fun logStreams(`value`: Output<List<GangliaLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("lsfageibojirfwhd")
    public suspend fun logStreams(vararg values: Output<GangliaLayerCloudwatchConfigurationLogStreamArgs>) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xlxkfhncptaxyxct")
    public suspend fun logStreams(values: List<Output<GangliaLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rmhxwouaodrlixlb")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("ieaumqrpxlqfkrrr")
    public suspend fun logStreams(`value`: List<GangliaLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wfjxutydemieyqky")
    public suspend fun logStreams(argument: List<suspend GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wqsjydqbkodcpooj")
    public suspend fun logStreams(vararg argument: suspend GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qsphqefexgaaimem")
    public suspend fun logStreams(argument: suspend GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GangliaLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("alrpiumhrkavwsol")
    public suspend fun logStreams(vararg values: GangliaLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): GangliaLayerCloudwatchConfigurationArgs =
        GangliaLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
