@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.GangliaLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling
 * @property enable
 * @property upscaling
 */
public data class GangliaLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<GangliaLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<GangliaLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.GangliaLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.GangliaLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.GangliaLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GangliaLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class GangliaLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<GangliaLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<GangliaLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value
     */
    @JvmName("ypoyvpnwxnafxtrb")
    public suspend fun downscaling(`value`: Output<GangliaLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value
     */
    @JvmName("wavulhtwhhgvbfik")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("lirvphjafvkduuvq")
    public suspend fun upscaling(`value`: Output<GangliaLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value
     */
    @JvmName("fbeumntqoaftiabw")
    public suspend fun downscaling(`value`: GangliaLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ukbrdtqncrmgjpcf")
    public suspend fun downscaling(argument: suspend GangliaLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = GangliaLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("rafsggsdlxwqewtd")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("vfjvjtwlwmlcelkw")
    public suspend fun upscaling(`value`: GangliaLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("brdvicbpmainirxa")
    public suspend fun upscaling(argument: suspend GangliaLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = GangliaLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): GangliaLayerLoadBasedAutoScalingArgs = GangliaLayerLoadBasedAutoScalingArgs(
        downscaling = downscaling,
        enable = enable,
        upscaling = upscaling,
    )
}
