@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.HaproxyLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams
 */
public data class HaproxyLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<HaproxyLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.HaproxyLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.HaproxyLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.HaproxyLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HaproxyLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class HaproxyLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<HaproxyLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("okgqhiauylembysk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("pikpnarhnjmxjeko")
    public suspend fun logStreams(`value`: Output<List<HaproxyLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("dncgwtyjeqrmygrc")
    public suspend fun logStreams(vararg values: Output<HaproxyLayerCloudwatchConfigurationLogStreamArgs>) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mukvbnabglbjiegp")
    public suspend fun logStreams(values: List<Output<HaproxyLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qfljgpxlebbxavde")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("ikwldphldjimfmkl")
    public suspend fun logStreams(`value`: List<HaproxyLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("icctqmxcehpoobft")
    public suspend fun logStreams(argument: List<suspend HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("enaqmkgfitllbmci")
    public suspend fun logStreams(vararg argument: suspend HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mfodnbvmpbraurcr")
    public suspend fun logStreams(argument: suspend HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HaproxyLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("yptroriqqeamrfmk")
    public suspend fun logStreams(vararg values: HaproxyLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): HaproxyLayerCloudwatchConfigurationArgs =
        HaproxyLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
