@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.InstanceEbsBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination
 * @property deviceName
 * @property iops
 * @property snapshotId
 * @property volumeSize
 * @property volumeType
 */
public data class InstanceEbsBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>,
    public val iops: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.InstanceEbsBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.InstanceEbsBlockDeviceArgs =
        com.pulumi.aws.opsworks.inputs.InstanceEbsBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceEbsBlockDeviceArgs].
 */
@PulumiTagMarker
public class InstanceEbsBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var iops: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("aftdionysvnnueam")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value
     */
    @JvmName("rngobhfnaapcwqae")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("djffsjftdwujvimv")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value
     */
    @JvmName("ifqahtvyayerjsuu")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value
     */
    @JvmName("yntmdimvmwxychbj")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value
     */
    @JvmName("tdhqhbltaoiuenxb")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value
     */
    @JvmName("xutejegurndxuwhy")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmajjclenqmsfndt")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvlbghwahqitjdhw")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value
     */
    @JvmName("llbfmwiqbidrxulp")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ietyyrwjmyqvxqao")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("lpklwnwhxrljjiij")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): InstanceEbsBlockDeviceArgs = InstanceEbsBlockDeviceArgs(
        deleteOnTermination = deleteOnTermination,
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        iops = iops,
        snapshotId = snapshotId,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
