@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.MemcachedLayerCloudwatchConfigurationLogStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchCount
 * @property batchSize
 * @property bufferDuration
 * @property datetimeFormat
 * @property encoding
 * @property file
 * @property fileFingerprintLines
 * @property initialPosition
 * @property logGroupName
 * @property multilineStartPattern
 * @property timeZone
 */
public data class MemcachedLayerCloudwatchConfigurationLogStreamArgs(
    public val batchCount: Output<Int>? = null,
    public val batchSize: Output<Int>? = null,
    public val bufferDuration: Output<Int>? = null,
    public val datetimeFormat: Output<String>? = null,
    public val encoding: Output<String>? = null,
    public val `file`: Output<String>,
    public val fileFingerprintLines: Output<String>? = null,
    public val initialPosition: Output<String>? = null,
    public val logGroupName: Output<String>,
    public val multilineStartPattern: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.MemcachedLayerCloudwatchConfigurationLogStreamArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.MemcachedLayerCloudwatchConfigurationLogStreamArgs =
        com.pulumi.aws.opsworks.inputs.MemcachedLayerCloudwatchConfigurationLogStreamArgs.builder()
            .batchCount(batchCount?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .bufferDuration(bufferDuration?.applyValue({ args0 -> args0 }))
            .datetimeFormat(datetimeFormat?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .`file`(`file`.applyValue({ args0 -> args0 }))
            .fileFingerprintLines(fileFingerprintLines?.applyValue({ args0 -> args0 }))
            .initialPosition(initialPosition?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .multilineStartPattern(multilineStartPattern?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemcachedLayerCloudwatchConfigurationLogStreamArgs].
 */
@PulumiTagMarker
public class MemcachedLayerCloudwatchConfigurationLogStreamArgsBuilder internal constructor() {
    private var batchCount: Output<Int>? = null

    private var batchSize: Output<Int>? = null

    private var bufferDuration: Output<Int>? = null

    private var datetimeFormat: Output<String>? = null

    private var encoding: Output<String>? = null

    private var `file`: Output<String>? = null

    private var fileFingerprintLines: Output<String>? = null

    private var initialPosition: Output<String>? = null

    private var logGroupName: Output<String>? = null

    private var multilineStartPattern: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qcqjbucoxrbbwxjj")
    public suspend fun batchCount(`value`: Output<Int>) {
        this.batchCount = value
    }

    /**
     * @param value
     */
    @JvmName("iutirboechcrclds")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value
     */
    @JvmName("eodhatifcyphlkff")
    public suspend fun bufferDuration(`value`: Output<Int>) {
        this.bufferDuration = value
    }

    /**
     * @param value
     */
    @JvmName("spnvpkgeodpvgiwv")
    public suspend fun datetimeFormat(`value`: Output<String>) {
        this.datetimeFormat = value
    }

    /**
     * @param value
     */
    @JvmName("uvfmaskwfnkcudox")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value
     */
    @JvmName("iglycukfkeclfnxn")
    public suspend fun `file`(`value`: Output<String>) {
        this.`file` = value
    }

    /**
     * @param value
     */
    @JvmName("forrlkwletgeptrl")
    public suspend fun fileFingerprintLines(`value`: Output<String>) {
        this.fileFingerprintLines = value
    }

    /**
     * @param value
     */
    @JvmName("lfhteqdouubawosm")
    public suspend fun initialPosition(`value`: Output<String>) {
        this.initialPosition = value
    }

    /**
     * @param value
     */
    @JvmName("hcnxomrstqujtpbr")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("jysgsdibgnasupwx")
    public suspend fun multilineStartPattern(`value`: Output<String>) {
        this.multilineStartPattern = value
    }

    /**
     * @param value
     */
    @JvmName("tphfnvurkdjbrayx")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value
     */
    @JvmName("ayqweefnvmlvomse")
    public suspend fun batchCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("ittgurhkuipgsnwg")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcygruvlsehuruud")
    public suspend fun bufferDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("emveahylwmledmsa")
    public suspend fun datetimeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datetimeFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("vemomkebsieokgwe")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value
     */
    @JvmName("fcxfmkfjqawxrsdd")
    public suspend fun `file`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmaxheayafcudyjp")
    public suspend fun fileFingerprintLines(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFingerprintLines = mapped
    }

    /**
     * @param value
     */
    @JvmName("avdxxqroxxgovbhv")
    public suspend fun initialPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPosition = mapped
    }

    /**
     * @param value
     */
    @JvmName("iajkuikcwvdhowjn")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("jschdfaxmtitgvpq")
    public suspend fun multilineStartPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multilineStartPattern = mapped
    }

    /**
     * @param value
     */
    @JvmName("psvdanqvtthvqhhx")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): MemcachedLayerCloudwatchConfigurationLogStreamArgs =
        MemcachedLayerCloudwatchConfigurationLogStreamArgs(
            batchCount = batchCount,
            batchSize = batchSize,
            bufferDuration = bufferDuration,
            datetimeFormat = datetimeFormat,
            encoding = encoding,
            `file` = `file` ?: throw PulumiNullFieldException("file"),
            fileFingerprintLines = fileFingerprintLines,
            initialPosition = initialPosition,
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
            multilineStartPattern = multilineStartPattern,
            timeZone = timeZone,
        )
}
