@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.MysqlLayerCloudwatchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property enabled
 * @property logStreams
 */
public data class MysqlLayerCloudwatchConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
    public val logStreams: Output<List<MysqlLayerCloudwatchConfigurationLogStreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.MysqlLayerCloudwatchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.MysqlLayerCloudwatchConfigurationArgs =
        com.pulumi.aws.opsworks.inputs.MysqlLayerCloudwatchConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .logStreams(
                logStreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MysqlLayerCloudwatchConfigurationArgs].
 */
@PulumiTagMarker
public class MysqlLayerCloudwatchConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logStreams: Output<List<MysqlLayerCloudwatchConfigurationLogStreamArgs>>? = null

    /**
     * @param value
     */
    @JvmName("xmeipwlfxstfxlmc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("dnvrlhtehyunywpb")
    public suspend fun logStreams(`value`: Output<List<MysqlLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = value
    }

    @JvmName("uanhmelrjkyoilhn")
    public suspend fun logStreams(vararg values: Output<MysqlLayerCloudwatchConfigurationLogStreamArgs>) {
        this.logStreams = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("afvdsefnqftybcch")
    public suspend fun logStreams(values: List<Output<MysqlLayerCloudwatchConfigurationLogStreamArgs>>) {
        this.logStreams = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ncbijduwayfvufoj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaiivnabfocxuxht")
    public suspend fun logStreams(`value`: List<MysqlLayerCloudwatchConfigurationLogStreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rjiveywvaupmecah")
    public suspend fun logStreams(argument: List<suspend MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gvoniywvpdacsick")
    public suspend fun logStreams(vararg argument: suspend MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wkriekbmiwwjqbtf")
    public suspend fun logStreams(argument: suspend MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MysqlLayerCloudwatchConfigurationLogStreamArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logStreams = mapped
    }

    /**
     * @param values
     */
    @JvmName("xokpbaihgpkhybll")
    public suspend fun logStreams(vararg values: MysqlLayerCloudwatchConfigurationLogStreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logStreams = mapped
    }

    internal fun build(): MysqlLayerCloudwatchConfigurationArgs =
        MysqlLayerCloudwatchConfigurationArgs(
            enabled = enabled,
            logStreams = logStreams,
        )
}
