@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingDownscalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms
 * @property cpuThreshold
 * @property ignoreMetricsTime
 * @property instanceCount
 * @property loadThreshold
 * @property memoryThreshold
 * @property thresholdsWaitTime
 */
public data class NodejsAppLayerLoadBasedAutoScalingDownscalingArgs(
    public val alarms: Output<List<String>>? = null,
    public val cpuThreshold: Output<Double>? = null,
    public val ignoreMetricsTime: Output<Int>? = null,
    public val instanceCount: Output<Int>? = null,
    public val loadThreshold: Output<Double>? = null,
    public val memoryThreshold: Output<Double>? = null,
    public val thresholdsWaitTime: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingDownscalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingDownscalingArgs =
        com.pulumi.aws.opsworks.inputs.NodejsAppLayerLoadBasedAutoScalingDownscalingArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpuThreshold(cpuThreshold?.applyValue({ args0 -> args0 }))
            .ignoreMetricsTime(ignoreMetricsTime?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .loadThreshold(loadThreshold?.applyValue({ args0 -> args0 }))
            .memoryThreshold(memoryThreshold?.applyValue({ args0 -> args0 }))
            .thresholdsWaitTime(thresholdsWaitTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodejsAppLayerLoadBasedAutoScalingDownscalingArgs].
 */
@PulumiTagMarker
public class NodejsAppLayerLoadBasedAutoScalingDownscalingArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    private var cpuThreshold: Output<Double>? = null

    private var ignoreMetricsTime: Output<Int>? = null

    private var instanceCount: Output<Int>? = null

    private var loadThreshold: Output<Double>? = null

    private var memoryThreshold: Output<Double>? = null

    private var thresholdsWaitTime: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("qlycaxluhtsravri")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("lpcpkvoyscjnfhyl")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xumlremkeiaeyauj")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kkmpklvbfxwirxbx")
    public suspend fun cpuThreshold(`value`: Output<Double>) {
        this.cpuThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("pbfseobyiitrymem")
    public suspend fun ignoreMetricsTime(`value`: Output<Int>) {
        this.ignoreMetricsTime = value
    }

    /**
     * @param value
     */
    @JvmName("vjijojvuyqfpxrsp")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value
     */
    @JvmName("xstmimldavauoaiq")
    public suspend fun loadThreshold(`value`: Output<Double>) {
        this.loadThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("mbfxiqndaqyfultw")
    public suspend fun memoryThreshold(`value`: Output<Double>) {
        this.memoryThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("qybykjqtvgrsvfkw")
    public suspend fun thresholdsWaitTime(`value`: Output<Int>) {
        this.thresholdsWaitTime = value
    }

    /**
     * @param value
     */
    @JvmName("ykkghpnhwuthckmb")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values
     */
    @JvmName("tjtnspbtfmoqnxgs")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param value
     */
    @JvmName("bgdjojjjvflvtfwq")
    public suspend fun cpuThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("rurxtldvnasuqasr")
    public suspend fun ignoreMetricsTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMetricsTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("gybeebuwlnicvmxx")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("ovifopqrdixcecck")
    public suspend fun loadThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("bbxisaktnkcjgmrc")
    public suspend fun memoryThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("yparqlsdboqgqnvu")
    public suspend fun thresholdsWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdsWaitTime = mapped
    }

    internal fun build(): NodejsAppLayerLoadBasedAutoScalingDownscalingArgs =
        NodejsAppLayerLoadBasedAutoScalingDownscalingArgs(
            alarms = alarms,
            cpuThreshold = cpuThreshold,
            ignoreMetricsTime = ignoreMetricsTime,
            instanceCount = instanceCount,
            loadThreshold = loadThreshold,
            memoryThreshold = memoryThreshold,
            thresholdsWaitTime = thresholdsWaitTime,
        )
}
