@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationLogStreamArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchCount
 * @property batchSize
 * @property bufferDuration
 * @property datetimeFormat
 * @property encoding
 * @property file
 * @property fileFingerprintLines
 * @property initialPosition
 * @property logGroupName
 * @property multilineStartPattern
 * @property timeZone
 */
public data class PhpAppLayerCloudwatchConfigurationLogStreamArgs(
    public val batchCount: Output<Int>? = null,
    public val batchSize: Output<Int>? = null,
    public val bufferDuration: Output<Int>? = null,
    public val datetimeFormat: Output<String>? = null,
    public val encoding: Output<String>? = null,
    public val `file`: Output<String>,
    public val fileFingerprintLines: Output<String>? = null,
    public val initialPosition: Output<String>? = null,
    public val logGroupName: Output<String>,
    public val multilineStartPattern: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationLogStreamArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationLogStreamArgs =
        com.pulumi.aws.opsworks.inputs.PhpAppLayerCloudwatchConfigurationLogStreamArgs.builder()
            .batchCount(batchCount?.applyValue({ args0 -> args0 }))
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .bufferDuration(bufferDuration?.applyValue({ args0 -> args0 }))
            .datetimeFormat(datetimeFormat?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0 }))
            .`file`(`file`.applyValue({ args0 -> args0 }))
            .fileFingerprintLines(fileFingerprintLines?.applyValue({ args0 -> args0 }))
            .initialPosition(initialPosition?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName.applyValue({ args0 -> args0 }))
            .multilineStartPattern(multilineStartPattern?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PhpAppLayerCloudwatchConfigurationLogStreamArgs].
 */
@PulumiTagMarker
public class PhpAppLayerCloudwatchConfigurationLogStreamArgsBuilder internal constructor() {
    private var batchCount: Output<Int>? = null

    private var batchSize: Output<Int>? = null

    private var bufferDuration: Output<Int>? = null

    private var datetimeFormat: Output<String>? = null

    private var encoding: Output<String>? = null

    private var `file`: Output<String>? = null

    private var fileFingerprintLines: Output<String>? = null

    private var initialPosition: Output<String>? = null

    private var logGroupName: Output<String>? = null

    private var multilineStartPattern: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("csfmdkmchwvqhxmd")
    public suspend fun batchCount(`value`: Output<Int>) {
        this.batchCount = value
    }

    /**
     * @param value
     */
    @JvmName("fkvujbeqxocmybwa")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value
     */
    @JvmName("hpxhyopuddmqcfdc")
    public suspend fun bufferDuration(`value`: Output<Int>) {
        this.bufferDuration = value
    }

    /**
     * @param value
     */
    @JvmName("xwxwmybjuixxhirm")
    public suspend fun datetimeFormat(`value`: Output<String>) {
        this.datetimeFormat = value
    }

    /**
     * @param value
     */
    @JvmName("lyeormvdsqfqlnvj")
    public suspend fun encoding(`value`: Output<String>) {
        this.encoding = value
    }

    /**
     * @param value
     */
    @JvmName("qjkkokbidgccrrqc")
    public suspend fun `file`(`value`: Output<String>) {
        this.`file` = value
    }

    /**
     * @param value
     */
    @JvmName("lujytiqxlfxnnhtr")
    public suspend fun fileFingerprintLines(`value`: Output<String>) {
        this.fileFingerprintLines = value
    }

    /**
     * @param value
     */
    @JvmName("syppbsoasxjaemco")
    public suspend fun initialPosition(`value`: Output<String>) {
        this.initialPosition = value
    }

    /**
     * @param value
     */
    @JvmName("xsepeupvmrpyhvkw")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("nmrleoxduatlpvfs")
    public suspend fun multilineStartPattern(`value`: Output<String>) {
        this.multilineStartPattern = value
    }

    /**
     * @param value
     */
    @JvmName("vhuyceiuphwwidhy")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value
     */
    @JvmName("bseqgxlkiaqwnoxw")
    public suspend fun batchCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("slrcenktkpcqiifo")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("qhuptexypvvwglsm")
    public suspend fun bufferDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcomtlvyynlqfsvp")
    public suspend fun datetimeFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datetimeFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktkgingbquphiqsx")
    public suspend fun encoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param value
     */
    @JvmName("klfdgcxatugaffku")
    public suspend fun `file`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypnhagsmwrptruhy")
    public suspend fun fileFingerprintLines(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFingerprintLines = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqwbcuixkxobeoan")
    public suspend fun initialPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialPosition = mapped
    }

    /**
     * @param value
     */
    @JvmName("uiyvlwvmngjxxvxw")
    public suspend fun logGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbgjncqexbkoxspf")
    public suspend fun multilineStartPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multilineStartPattern = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhneptewvlwprebr")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): PhpAppLayerCloudwatchConfigurationLogStreamArgs =
        PhpAppLayerCloudwatchConfigurationLogStreamArgs(
            batchCount = batchCount,
            batchSize = batchSize,
            bufferDuration = bufferDuration,
            datetimeFormat = datetimeFormat,
            encoding = encoding,
            `file` = `file` ?: throw PulumiNullFieldException("file"),
            fileFingerprintLines = fileFingerprintLines,
            initialPosition = initialPosition,
            logGroupName = logGroupName ?: throw PulumiNullFieldException("logGroupName"),
            multilineStartPattern = multilineStartPattern,
            timeZone = timeZone,
        )
}
