@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property downscaling
 * @property enable
 * @property upscaling
 */
public data class RailsAppLayerLoadBasedAutoScalingArgs(
    public val downscaling: Output<RailsAppLayerLoadBasedAutoScalingDownscalingArgs>? = null,
    public val enable: Output<Boolean>? = null,
    public val upscaling: Output<RailsAppLayerLoadBasedAutoScalingUpscalingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingArgs =
        com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingArgs.builder()
            .downscaling(downscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .upscaling(upscaling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RailsAppLayerLoadBasedAutoScalingArgs].
 */
@PulumiTagMarker
public class RailsAppLayerLoadBasedAutoScalingArgsBuilder internal constructor() {
    private var downscaling: Output<RailsAppLayerLoadBasedAutoScalingDownscalingArgs>? = null

    private var enable: Output<Boolean>? = null

    private var upscaling: Output<RailsAppLayerLoadBasedAutoScalingUpscalingArgs>? = null

    /**
     * @param value
     */
    @JvmName("swaammelwdygeoix")
    public suspend fun downscaling(`value`: Output<RailsAppLayerLoadBasedAutoScalingDownscalingArgs>) {
        this.downscaling = value
    }

    /**
     * @param value
     */
    @JvmName("bllrgrsysktdllun")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value
     */
    @JvmName("qckjbfqvboibtvky")
    public suspend fun upscaling(`value`: Output<RailsAppLayerLoadBasedAutoScalingUpscalingArgs>) {
        this.upscaling = value
    }

    /**
     * @param value
     */
    @JvmName("iqqtdmiixpngpdfw")
    public suspend fun downscaling(`value`: RailsAppLayerLoadBasedAutoScalingDownscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("twgvbovsnflcbnql")
    public suspend fun downscaling(argument: suspend RailsAppLayerLoadBasedAutoScalingDownscalingArgsBuilder.() -> Unit) {
        val toBeMapped = RailsAppLayerLoadBasedAutoScalingDownscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.downscaling = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivcsejftbtokarwb")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value
     */
    @JvmName("afxhyudydkbxvnmd")
    public suspend fun upscaling(`value`: RailsAppLayerLoadBasedAutoScalingUpscalingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upscaling = mapped
    }

    /**
     * @param argument
     */
    @JvmName("omngiftrlbeynqqn")
    public suspend fun upscaling(argument: suspend RailsAppLayerLoadBasedAutoScalingUpscalingArgsBuilder.() -> Unit) {
        val toBeMapped = RailsAppLayerLoadBasedAutoScalingUpscalingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.upscaling = mapped
    }

    internal fun build(): RailsAppLayerLoadBasedAutoScalingArgs =
        RailsAppLayerLoadBasedAutoScalingArgs(
            downscaling = downscaling,
            enable = enable,
            upscaling = upscaling,
        )
}
