@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.inputs

import com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingDownscalingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms
 * @property cpuThreshold
 * @property ignoreMetricsTime
 * @property instanceCount
 * @property loadThreshold
 * @property memoryThreshold
 * @property thresholdsWaitTime
 */
public data class RailsAppLayerLoadBasedAutoScalingDownscalingArgs(
    public val alarms: Output<List<String>>? = null,
    public val cpuThreshold: Output<Double>? = null,
    public val ignoreMetricsTime: Output<Int>? = null,
    public val instanceCount: Output<Int>? = null,
    public val loadThreshold: Output<Double>? = null,
    public val memoryThreshold: Output<Double>? = null,
    public val thresholdsWaitTime: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingDownscalingArgs> {
    override fun toJava(): com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingDownscalingArgs =
        com.pulumi.aws.opsworks.inputs.RailsAppLayerLoadBasedAutoScalingDownscalingArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpuThreshold(cpuThreshold?.applyValue({ args0 -> args0 }))
            .ignoreMetricsTime(ignoreMetricsTime?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .loadThreshold(loadThreshold?.applyValue({ args0 -> args0 }))
            .memoryThreshold(memoryThreshold?.applyValue({ args0 -> args0 }))
            .thresholdsWaitTime(thresholdsWaitTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RailsAppLayerLoadBasedAutoScalingDownscalingArgs].
 */
@PulumiTagMarker
public class RailsAppLayerLoadBasedAutoScalingDownscalingArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    private var cpuThreshold: Output<Double>? = null

    private var ignoreMetricsTime: Output<Int>? = null

    private var instanceCount: Output<Int>? = null

    private var loadThreshold: Output<Double>? = null

    private var memoryThreshold: Output<Double>? = null

    private var thresholdsWaitTime: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("nknvnhxjitpjhvpx")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("ckgsxptqtwrkwvbc")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xjyhpkfbjqdvrpkd")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sjlsskgcohrntlmc")
    public suspend fun cpuThreshold(`value`: Output<Double>) {
        this.cpuThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("awtougkpyjnqyuqn")
    public suspend fun ignoreMetricsTime(`value`: Output<Int>) {
        this.ignoreMetricsTime = value
    }

    /**
     * @param value
     */
    @JvmName("kqbwhdotkqvuwfkx")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value
     */
    @JvmName("gsoajieipidjeska")
    public suspend fun loadThreshold(`value`: Output<Double>) {
        this.loadThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("agbymlfrbowcahnb")
    public suspend fun memoryThreshold(`value`: Output<Double>) {
        this.memoryThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("tokgnjbhhsgmovqh")
    public suspend fun thresholdsWaitTime(`value`: Output<Int>) {
        this.thresholdsWaitTime = value
    }

    /**
     * @param value
     */
    @JvmName("rqetfmvsknbocmcy")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values
     */
    @JvmName("fvulnsknwlfvdjys")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param value
     */
    @JvmName("loeshirksxuhhhqn")
    public suspend fun cpuThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjlxldpfkesndorc")
    public suspend fun ignoreMetricsTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMetricsTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydbwealpgtawvxve")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("uhdxgswetuecglkn")
    public suspend fun loadThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("jffenfvxfrgwnfnp")
    public suspend fun memoryThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("wiwnvbaeebmtyqym")
    public suspend fun thresholdsWaitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdsWaitTime = mapped
    }

    internal fun build(): RailsAppLayerLoadBasedAutoScalingDownscalingArgs =
        RailsAppLayerLoadBasedAutoScalingDownscalingArgs(
            alarms = alarms,
            cpuThreshold = cpuThreshold,
            ignoreMetricsTime = ignoreMetricsTime,
            instanceCount = instanceCount,
            loadThreshold = loadThreshold,
            memoryThreshold = memoryThreshold,
            thresholdsWaitTime = thresholdsWaitTime,
        )
}
