@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Variable name.
 * @property secure Set visibility of the variable value to `true` or `false`.
 * @property value Variable value.
 */
public data class ApplicationEnvironment(
    public val key: String,
    public val secure: Boolean? = null,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.ApplicationEnvironment): ApplicationEnvironment = ApplicationEnvironment(
            key = javaType.key(),
            secure = javaType.secure().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
