@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchCount Specifies the max number of log events in a batch, up to `10000`. The default value is `1000`.
 * @property batchSize Specifies the maximum size of log events in a batch, in bytes, up to `1048576` bytes. The default value is `32768` bytes.
 * @property bufferDuration Specifies the time duration for the batching of log events. The minimum value is `5000` and default value is `5000`.
 * @property datetimeFormat Specifies how the timestamp is extracted from logs. For more information, see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
 * @property encoding Specifies the encoding of the log file so that the file can be read correctly. The default is `utf_8`.
 * @property file Specifies log files that you want to push to CloudWatch Logs. File can point to a specific file or multiple files (by using wild card characters such as /var/log/system.log*).
 * @property fileFingerprintLines Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited numbers, such as `1`, `2-5`. The default value is `1`.
 * @property initialPosition Specifies where to start to read data (`start_of_file` or `end_of_file`). The default is `start_of_file`.
 * @property logGroupName Specifies the destination log group. A log group is created automatically if it doesn't already exist.
 * @property multilineStartPattern Specifies the pattern for identifying the start of a log message.
 * @property timeZone Specifies the time zone of log event time stamps.
 */
public data class CustomLayerCloudwatchConfigurationLogStream(
    public val batchCount: Int? = null,
    public val batchSize: Int? = null,
    public val bufferDuration: Int? = null,
    public val datetimeFormat: String? = null,
    public val encoding: String? = null,
    public val `file`: String,
    public val fileFingerprintLines: String? = null,
    public val initialPosition: String? = null,
    public val logGroupName: String,
    public val multilineStartPattern: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.CustomLayerCloudwatchConfigurationLogStream): CustomLayerCloudwatchConfigurationLogStream = CustomLayerCloudwatchConfigurationLogStream(
            batchCount = javaType.batchCount().map({ args0 -> args0 }).orElse(null),
            batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
            bufferDuration = javaType.bufferDuration().map({ args0 -> args0 }).orElse(null),
            datetimeFormat = javaType.datetimeFormat().map({ args0 -> args0 }).orElse(null),
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            `file` = javaType.`file`(),
            fileFingerprintLines = javaType.fileFingerprintLines().map({ args0 -> args0 }).orElse(null),
            initialPosition = javaType.initialPosition().map({ args0 -> args0 }).orElse(null),
            logGroupName = javaType.logGroupName(),
            multilineStartPattern = javaType.multilineStartPattern().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
