@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarms Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter takes a list of up to five alarm names, which are case sensitive and must be in the same region as the stack.
 * @property cpuThreshold The CPU utilization threshold, as a percent of the available CPU. A value of -1 disables the threshold.
 * @property ignoreMetricsTime The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks Stacks should ignore metrics and suppress additional scaling events.
 * @property instanceCount The number of instances to add or remove when the load exceeds a threshold.
 * @property loadThreshold The load threshold. A value of -1 disables the threshold.
 * @property memoryThreshold The memory utilization threshold, as a percent of the available memory. A value of -1 disables the threshold.
 * @property thresholdsWaitTime The amount of time, in minutes, that the load must exceed a threshold before more instances are added or removed.
 */
public data class CustomLayerLoadBasedAutoScalingUpscaling(
    public val alarms: List<String>? = null,
    public val cpuThreshold: Double? = null,
    public val ignoreMetricsTime: Int? = null,
    public val instanceCount: Int? = null,
    public val loadThreshold: Double? = null,
    public val memoryThreshold: Double? = null,
    public val thresholdsWaitTime: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.CustomLayerLoadBasedAutoScalingUpscaling): CustomLayerLoadBasedAutoScalingUpscaling = CustomLayerLoadBasedAutoScalingUpscaling(
            alarms = javaType.alarms().map({ args0 -> args0 }),
            cpuThreshold = javaType.cpuThreshold().map({ args0 -> args0 }).orElse(null),
            ignoreMetricsTime = javaType.ignoreMetricsTime().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            loadThreshold = javaType.loadThreshold().map({ args0 -> args0 }).orElse(null),
            memoryThreshold = javaType.memoryThreshold().map({ args0 -> args0 }).orElse(null),
            thresholdsWaitTime = javaType.thresholdsWaitTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
