@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarms
 * @property cpuThreshold
 * @property ignoreMetricsTime
 * @property instanceCount
 * @property loadThreshold
 * @property memoryThreshold
 * @property thresholdsWaitTime
 */
public data class HaproxyLayerLoadBasedAutoScalingUpscaling(
    public val alarms: List<String>? = null,
    public val cpuThreshold: Double? = null,
    public val ignoreMetricsTime: Int? = null,
    public val instanceCount: Int? = null,
    public val loadThreshold: Double? = null,
    public val memoryThreshold: Double? = null,
    public val thresholdsWaitTime: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.HaproxyLayerLoadBasedAutoScalingUpscaling): HaproxyLayerLoadBasedAutoScalingUpscaling = HaproxyLayerLoadBasedAutoScalingUpscaling(
            alarms = javaType.alarms().map({ args0 -> args0 }),
            cpuThreshold = javaType.cpuThreshold().map({ args0 -> args0 }).orElse(null),
            ignoreMetricsTime = javaType.ignoreMetricsTime().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            loadThreshold = javaType.loadThreshold().map({ args0 -> args0 }).orElse(null),
            memoryThreshold = javaType.memoryThreshold().map({ args0 -> args0 }).orElse(null),
            thresholdsWaitTime = javaType.thresholdsWaitTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
