@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.opsworks.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property batchCount
 * @property batchSize
 * @property bufferDuration
 * @property datetimeFormat
 * @property encoding
 * @property file
 * @property fileFingerprintLines
 * @property initialPosition
 * @property logGroupName
 * @property multilineStartPattern
 * @property timeZone
 */
public data class RailsAppLayerCloudwatchConfigurationLogStream(
    public val batchCount: Int? = null,
    public val batchSize: Int? = null,
    public val bufferDuration: Int? = null,
    public val datetimeFormat: String? = null,
    public val encoding: String? = null,
    public val `file`: String,
    public val fileFingerprintLines: String? = null,
    public val initialPosition: String? = null,
    public val logGroupName: String,
    public val multilineStartPattern: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.opsworks.outputs.RailsAppLayerCloudwatchConfigurationLogStream): RailsAppLayerCloudwatchConfigurationLogStream =
            RailsAppLayerCloudwatchConfigurationLogStream(
                batchCount = javaType.batchCount().map({ args0 -> args0 }).orElse(null),
                batchSize = javaType.batchSize().map({ args0 -> args0 }).orElse(null),
                bufferDuration = javaType.bufferDuration().map({ args0 -> args0 }).orElse(null),
                datetimeFormat = javaType.datetimeFormat().map({ args0 -> args0 }).orElse(null),
                encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
                `file` = javaType.`file`(),
                fileFingerprintLines = javaType.fileFingerprintLines().map({ args0 -> args0 }).orElse(null),
                initialPosition = javaType.initialPosition().map({ args0 -> args0 }).orElse(null),
                logGroupName = javaType.logGroupName(),
                multilineStartPattern = javaType.multilineStartPattern().map({ args0 -> args0 }).orElse(null),
                timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            )
    }
}
