@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a member account in the current organization.
 * > **Note:** Account management must be done from the organization's root account.
 * > **Note:** By default, deleting this resource will only remove an AWS account from an organization. You must set the `close_on_deletion` flag to true to close the account. It is worth noting that quotas are enforced when using the `close_on_deletion` argument, which can produce a [CLOSE_ACCOUNT_QUOTA_EXCEEDED](https://docs.aws.amazon.com/organizations/latest/APIReference/API_CloseAccount.html) error, and require you to close the account manually.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const account = new aws.organizations.Account("account", {
 *     name: "my_new_account",
 *     email: "john@doe.org",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * account = aws.organizations.Account("account",
 *     name="my_new_account",
 *     email="john@doe.org")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new Aws.Organizations.Account("account", new()
 *     {
 *         Name = "my_new_account",
 *         Email = "john@doe.org",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewAccount(ctx, "account", &organizations.AccountArgs{
 * 			Name:  pulumi.String("my_new_account"),
 * 			Email: pulumi.String("john@doe.org"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Account;
 * import com.pulumi.aws.organizations.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .name("my_new_account")
 *             .email("john@doe.org")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   account:
 *     type: aws:organizations:Account
 *     properties:
 *       name: my_new_account
 *       email: john@doe.org
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the AWS member account using the `account_id`. For example:
 * ```sh
 * $ pulumi import aws:organizations/account:Account my_account 111111111111
 * ```
 * To import accounts that have set iam_user_access_to_billing, use the following:
 * ```sh
 * $ pulumi import aws:organizations/account:Account my_account 111111111111_ALLOW
 * ```
 * Certain resource arguments, like `role_name`, do not have an Organizations API method for reading the information after account creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property closeOnDeletion If true, a deletion event will close the account. Otherwise, it will only remove from the organization. This is not supported for GovCloud accounts.
 * @property createGovcloud Whether to also create a GovCloud account. The GovCloud account is tied to the main (commercial) account this resource creates. If `true`, the GovCloud account ID is available in the `govcloud_id` attribute. The only way to manage the GovCloud account with the provider is to subsequently import the account using this resource.
 * @property email Email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.
 * @property iamUserAccessToBilling If set to `ALLOW`, the new account enables IAM users and roles to access account billing information if they have the required permissions. If set to `DENY`, then only the root user (and no roles) of the new account can access account billing information. If this is unset, the AWS API will default this to `ALLOW`. If the resource is created and this option is changed, it will try to recreate the account.
 * @property name Friendly name for the member account.
 * The following arguments are optional:
 * @property parentId Parent Organizational Unit ID or Root ID for the account. Defaults to the Organization default Root ID. A configuration must be present for this argument to perform drift detection.
 * @property roleName The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the root account, allowing users in the root account to assume the role, as permitted by the root account administrator. The role has administrator permissions in the new member account. The Organizations API provides no method for reading this information after account creation, so the provider cannot perform drift detection on its value and will always show a difference for a configured value after import unless `ignoreChanges` is used.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AccountArgs(
    public val closeOnDeletion: Output<Boolean>? = null,
    public val createGovcloud: Output<Boolean>? = null,
    public val email: Output<String>? = null,
    public val iamUserAccessToBilling: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentId: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.AccountArgs> {
    override fun toJava(): com.pulumi.aws.organizations.AccountArgs =
        com.pulumi.aws.organizations.AccountArgs.builder()
            .closeOnDeletion(closeOnDeletion?.applyValue({ args0 -> args0 }))
            .createGovcloud(createGovcloud?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .iamUserAccessToBilling(iamUserAccessToBilling?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var closeOnDeletion: Output<Boolean>? = null

    private var createGovcloud: Output<Boolean>? = null

    private var email: Output<String>? = null

    private var iamUserAccessToBilling: Output<String>? = null

    private var name: Output<String>? = null

    private var parentId: Output<String>? = null

    private var roleName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value If true, a deletion event will close the account. Otherwise, it will only remove from the organization. This is not supported for GovCloud accounts.
     */
    @JvmName("myltaclnfqxinhts")
    public suspend fun closeOnDeletion(`value`: Output<Boolean>) {
        this.closeOnDeletion = value
    }

    /**
     * @param value Whether to also create a GovCloud account. The GovCloud account is tied to the main (commercial) account this resource creates. If `true`, the GovCloud account ID is available in the `govcloud_id` attribute. The only way to manage the GovCloud account with the provider is to subsequently import the account using this resource.
     */
    @JvmName("xtbimkaeqroshbew")
    public suspend fun createGovcloud(`value`: Output<Boolean>) {
        this.createGovcloud = value
    }

    /**
     * @param value Email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.
     */
    @JvmName("qxbvkhtirjlkotgd")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value If set to `ALLOW`, the new account enables IAM users and roles to access account billing information if they have the required permissions. If set to `DENY`, then only the root user (and no roles) of the new account can access account billing information. If this is unset, the AWS API will default this to `ALLOW`. If the resource is created and this option is changed, it will try to recreate the account.
     */
    @JvmName("osqhaekahubpbaxd")
    public suspend fun iamUserAccessToBilling(`value`: Output<String>) {
        this.iamUserAccessToBilling = value
    }

    /**
     * @param value Friendly name for the member account.
     * The following arguments are optional:
     */
    @JvmName("quffmpsfuhjsyvmb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parent Organizational Unit ID or Root ID for the account. Defaults to the Organization default Root ID. A configuration must be present for this argument to perform drift detection.
     */
    @JvmName("pvgranqpeffeaxfx")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the root account, allowing users in the root account to assume the role, as permitted by the root account administrator. The role has administrator permissions in the new member account. The Organizations API provides no method for reading this information after account creation, so the provider cannot perform drift detection on its value and will always show a difference for a configured value after import unless `ignoreChanges` is used.
     */
    @JvmName("dhljaujciwhfqlhv")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nuxaurqvmmauytad")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If true, a deletion event will close the account. Otherwise, it will only remove from the organization. This is not supported for GovCloud accounts.
     */
    @JvmName("cofrheuxmgskyged")
    public suspend fun closeOnDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closeOnDeletion = mapped
    }

    /**
     * @param value Whether to also create a GovCloud account. The GovCloud account is tied to the main (commercial) account this resource creates. If `true`, the GovCloud account ID is available in the `govcloud_id` attribute. The only way to manage the GovCloud account with the provider is to subsequently import the account using this resource.
     */
    @JvmName("avwntrxyvjawhjmf")
    public suspend fun createGovcloud(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createGovcloud = mapped
    }

    /**
     * @param value Email address of the owner to assign to the new member account. This email address must not already be associated with another AWS account.
     */
    @JvmName("pyqhltxffdyxeywm")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value If set to `ALLOW`, the new account enables IAM users and roles to access account billing information if they have the required permissions. If set to `DENY`, then only the root user (and no roles) of the new account can access account billing information. If this is unset, the AWS API will default this to `ALLOW`. If the resource is created and this option is changed, it will try to recreate the account.
     */
    @JvmName("pvpiowobxacdboau")
    public suspend fun iamUserAccessToBilling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamUserAccessToBilling = mapped
    }

    /**
     * @param value Friendly name for the member account.
     * The following arguments are optional:
     */
    @JvmName("bqwruykboibumbnl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parent Organizational Unit ID or Root ID for the account. Defaults to the Organization default Root ID. A configuration must be present for this argument to perform drift detection.
     */
    @JvmName("adveulwceebjoxem")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value The name of an IAM role that Organizations automatically preconfigures in the new member account. This role trusts the root account, allowing users in the root account to assume the role, as permitted by the root account administrator. The role has administrator permissions in the new member account. The Organizations API provides no method for reading this information after account creation, so the provider cannot perform drift detection on its value and will always show a difference for a configured value after import unless `ignoreChanges` is used.
     */
    @JvmName("lfprebjqyjbioabr")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eebasalojesxmivf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pxpsdykovpnkfpkq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        closeOnDeletion = closeOnDeletion,
        createGovcloud = createGovcloud,
        email = email,
        iamUserAccessToBilling = iamUserAccessToBilling,
        name = name,
        parentId = parentId,
        roleName = roleName,
        tags = tags,
    )
}
