@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DelegatedAdministrator].
 */
@PulumiTagMarker
public class DelegatedAdministratorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DelegatedAdministratorArgs = DelegatedAdministratorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DelegatedAdministratorArgsBuilder.() -> Unit) {
        val builder = DelegatedAdministratorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DelegatedAdministrator {
        val builtJavaResource =
            com.pulumi.aws.organizations.DelegatedAdministrator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DelegatedAdministrator(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [AWS Organizations Delegated Administrator](https://docs.aws.amazon.com/organizations/latest/APIReference/API_RegisterDelegatedAdministrator.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.DelegatedAdministrator("example", {
 *     accountId: "123456789012",
 *     servicePrincipal: "principal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.DelegatedAdministrator("example",
 *     account_id="123456789012",
 *     service_principal="principal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.DelegatedAdministrator("example", new()
 *     {
 *         AccountId = "123456789012",
 *         ServicePrincipal = "principal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewDelegatedAdministrator(ctx, "example", &organizations.DelegatedAdministratorArgs{
 * 			AccountId:        pulumi.String("123456789012"),
 * 			ServicePrincipal: pulumi.String("principal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.DelegatedAdministrator;
 * import com.pulumi.aws.organizations.DelegatedAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DelegatedAdministrator("example", DelegatedAdministratorArgs.builder()
 *             .accountId("123456789012")
 *             .servicePrincipal("principal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:DelegatedAdministrator
 *     properties:
 *       accountId: '123456789012'
 *       servicePrincipal: principal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_organizations_delegated_administrator` using the account ID and its service principal. For example:
 * ```sh
 * $ pulumi import aws:organizations/delegatedAdministrator:DelegatedAdministrator example 123456789012/config.amazonaws.com
 * ```
 */
public class DelegatedAdministrator internal constructor(
    override val javaResource: com.pulumi.aws.organizations.DelegatedAdministrator,
) : KotlinCustomResource(javaResource, DelegatedAdministratorMapper) {
    /**
     * The account ID number of the member account in the organization to register as a delegated administrator.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the delegated administrator's account.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date when the account was made a delegated administrator.
     */
    public val delegationEnabledDate: Output<String>
        get() = javaResource.delegationEnabledDate().applyValue({ args0 -> args0 })

    /**
     * The email address that is associated with the delegated administrator's AWS account.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * The method by which the delegated administrator's account joined the organization.
     */
    public val joinedMethod: Output<String>
        get() = javaResource.joinedMethod().applyValue({ args0 -> args0 })

    /**
     * The date when the delegated administrator's account became a part of the organization.
     */
    public val joinedTimestamp: Output<String>
        get() = javaResource.joinedTimestamp().applyValue({ args0 -> args0 })

    /**
     * The friendly name of the delegated administrator's account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The service principal of the AWS service for which you want to make the member account a delegated administrator.
     */
    public val servicePrincipal: Output<String>
        get() = javaResource.servicePrincipal().applyValue({ args0 -> args0 })

    /**
     * The status of the delegated administrator's account in the organization.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DelegatedAdministratorMapper : ResourceMapper<DelegatedAdministrator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.organizations.DelegatedAdministrator::class == javaResource::class

    override fun map(javaResource: Resource): DelegatedAdministrator =
        DelegatedAdministrator(javaResource as com.pulumi.aws.organizations.DelegatedAdministrator)
}

/**
 * @see [DelegatedAdministrator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DelegatedAdministrator].
 */
public suspend fun delegatedAdministrator(
    name: String,
    block: suspend DelegatedAdministratorResourceBuilder.() -> Unit,
): DelegatedAdministrator {
    val builder = DelegatedAdministratorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DelegatedAdministrator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun delegatedAdministrator(name: String): DelegatedAdministrator {
    val builder = DelegatedAdministratorResourceBuilder()
    builder.name(name)
    return builder.build()
}
