@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to attach an AWS Organizations policy to an organization account, root, or unit.
 * ## Example Usage
 * ### Organization Account
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const account = new aws.organizations.PolicyAttachment("account", {
 *     policyId: example.id,
 *     targetId: "123456789012",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * account = aws.organizations.PolicyAttachment("account",
 *     policy_id=example["id"],
 *     target_id="123456789012")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new Aws.Organizations.PolicyAttachment("account", new()
 *     {
 *         PolicyId = example.Id,
 *         TargetId = "123456789012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewPolicyAttachment(ctx, "account", &organizations.PolicyAttachmentArgs{
 * 			PolicyId: pulumi.Any(example.Id),
 * 			TargetId: pulumi.String("123456789012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new PolicyAttachment("account", PolicyAttachmentArgs.builder()
 *             .policyId(example.id())
 *             .targetId("123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   account:
 *     type: aws:organizations:PolicyAttachment
 *     properties:
 *       policyId: ${example.id}
 *       targetId: '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Root
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const root = new aws.organizations.PolicyAttachment("root", {
 *     policyId: example.id,
 *     targetId: exampleAwsOrganizationsOrganization.roots[0].id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * root = aws.organizations.PolicyAttachment("root",
 *     policy_id=example["id"],
 *     target_id=example_aws_organizations_organization["roots"][0]["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var root = new Aws.Organizations.PolicyAttachment("root", new()
 *     {
 *         PolicyId = example.Id,
 *         TargetId = exampleAwsOrganizationsOrganization.Roots[0].Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewPolicyAttachment(ctx, "root", &organizations.PolicyAttachmentArgs{
 * 			PolicyId: pulumi.Any(example.Id),
 * 			TargetId: pulumi.Any(exampleAwsOrganizationsOrganization.Roots[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var root = new PolicyAttachment("root", PolicyAttachmentArgs.builder()
 *             .policyId(example.id())
 *             .targetId(exampleAwsOrganizationsOrganization.roots()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   root:
 *     type: aws:organizations:PolicyAttachment
 *     properties:
 *       policyId: ${example.id}
 *       targetId: ${exampleAwsOrganizationsOrganization.roots[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Unit
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const unit = new aws.organizations.PolicyAttachment("unit", {
 *     policyId: example.id,
 *     targetId: exampleAwsOrganizationsOrganizationalUnit.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * unit = aws.organizations.PolicyAttachment("unit",
 *     policy_id=example["id"],
 *     target_id=example_aws_organizations_organizational_unit["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var unit = new Aws.Organizations.PolicyAttachment("unit", new()
 *     {
 *         PolicyId = example.Id,
 *         TargetId = exampleAwsOrganizationsOrganizationalUnit.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewPolicyAttachment(ctx, "unit", &organizations.PolicyAttachmentArgs{
 * 			PolicyId: pulumi.Any(example.Id),
 * 			TargetId: pulumi.Any(exampleAwsOrganizationsOrganizationalUnit.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.PolicyAttachment;
 * import com.pulumi.aws.organizations.PolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var unit = new PolicyAttachment("unit", PolicyAttachmentArgs.builder()
 *             .policyId(example.id())
 *             .targetId(exampleAwsOrganizationsOrganizationalUnit.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   unit:
 *     type: aws:organizations:PolicyAttachment
 *     properties:
 *       policyId: ${example.id}
 *       targetId: ${exampleAwsOrganizationsOrganizationalUnit.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_organizations_policy_attachment` using the target ID and policy ID. For example:
 * With an account target:
 * ```sh
 * $ pulumi import aws:organizations/policyAttachment:PolicyAttachment account 123456789012:p-12345678
 * ```
 * @property policyId The unique identifier (ID) of the policy that you want to attach to the target.
 * @property skipDestroy If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
 * @property targetId The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
 */
public data class PolicyAttachmentArgs(
    public val policyId: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.organizations.PolicyAttachmentArgs =
        com.pulumi.aws.organizations.PolicyAttachmentArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The unique identifier (ID) of the policy that you want to attach to the target.
     */
    @JvmName("fyyknvudsgifjase")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("rbabyphcwkonjvjg")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
     */
    @JvmName("qgownuivnligrjgs")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The unique identifier (ID) of the policy that you want to attach to the target.
     */
    @JvmName("lcbjywcunurxxuev")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value If set to `true`, destroy will **not** detach the policy and instead just remove the resource from state. This can be useful in situations where the attachment must be preserved to meet the AWS minimum requirement of 1 attached policy.
     */
    @JvmName("xmsykerjqyakosmo")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value The unique identifier (ID) of the root, organizational unit, or account number that you want to attach the policy to.
     */
    @JvmName("exaoqmvappjmfrkw")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        policyId = policyId,
        skipDestroy = skipDestroy,
        targetId = targetId,
    )
}
