@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResourcePolicy].
 */
@PulumiTagMarker
public class ResourcePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourcePolicyArgs = ResourcePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourcePolicyArgsBuilder.() -> Unit) {
        val builder = ResourcePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourcePolicy {
        val builtJavaResource = com.pulumi.aws.organizations.ResourcePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourcePolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a resource-based delegation policy that can be used to delegate policy management for AWS Organizations to specified member accounts to perform policy actions that are by default available only to the management account. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_delegate_policies.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.ResourcePolicy("example", {content: `{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.ResourcePolicy("example", content="""{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.ResourcePolicy("example", new()
 *     {
 *         Content = @"{
 *   ""Version"": ""2012-10-17"",
 *   ""Statement"": [
 *     {
 *       ""Sid"": ""DelegatingNecessaryDescribeListActions"",
 *       ""Effect"": ""Allow"",
 *       ""Principal"": {
 *         ""AWS"": ""arn:aws:iam::123456789012:root""
 *       },
 *       ""Action"": [
 *         ""organizations:DescribeOrganization"",
 *         ""organizations:DescribeOrganizationalUnit"",
 *         ""organizations:DescribeAccount"",
 *         ""organizations:DescribePolicy"",
 *         ""organizations:DescribeEffectivePolicy"",
 *         ""organizations:ListRoots"",
 *         ""organizations:ListOrganizationalUnitsForParent"",
 *         ""organizations:ListParents"",
 *         ""organizations:ListChildren"",
 *         ""organizations:ListAccounts"",
 *         ""organizations:ListAccountsForParent"",
 *         ""organizations:ListPolicies"",
 *         ""organizations:ListPoliciesForTarget"",
 *         ""organizations:ListTargetsForPolicy"",
 *         ""organizations:ListTagsForResource""
 *       ],
 *       ""Resource"": ""*""
 *     }
 *   ]
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewResourcePolicy(ctx, "example", &organizations.ResourcePolicyArgs{
 * 			Content: pulumi.String(`{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.ResourcePolicy;
 * import com.pulumi.aws.organizations.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .content("""
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:ResourcePolicy
 *     properties:
 *       content: |
 *         {
 *           "Version": "2012-10-17",
 *           "Statement": [
 *             {
 *               "Sid": "DelegatingNecessaryDescribeListActions",
 *               "Effect": "Allow",
 *               "Principal": {
 *                 "AWS": "arn:aws:iam::123456789012:root"
 *               },
 *               "Action": [
 *                 "organizations:DescribeOrganization",
 *                 "organizations:DescribeOrganizationalUnit",
 *                 "organizations:DescribeAccount",
 *                 "organizations:DescribePolicy",
 *                 "organizations:DescribeEffectivePolicy",
 *                 "organizations:ListRoots",
 *                 "organizations:ListOrganizationalUnitsForParent",
 *                 "organizations:ListParents",
 *                 "organizations:ListChildren",
 *                 "organizations:ListAccounts",
 *                 "organizations:ListAccountsForParent",
 *                 "organizations:ListPolicies",
 *                 "organizations:ListPoliciesForTarget",
 *                 "organizations:ListTargetsForPolicy",
 *                 "organizations:ListTagsForResource"
 *               ],
 *               "Resource": "*"
 *             }
 *           ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_organizations_resource_policy` using the resource policy ID. For example:
 * ```sh
 * $ pulumi import aws:organizations/resourcePolicy:ResourcePolicy example rp-12345678
 * ```
 */
public class ResourcePolicy internal constructor(
    override val javaResource: com.pulumi.aws.organizations.ResourcePolicy,
) : KotlinCustomResource(javaResource, ResourcePolicyMapper) {
    /**
     * Amazon Resource Name (ARN) of the resource policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Content for the resource policy. The text must be correctly formatted JSON that complies with the syntax for the resource policy's type. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_delegate_examples.html) for examples.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResourcePolicyMapper : ResourceMapper<ResourcePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.organizations.ResourcePolicy::class == javaResource::class

    override fun map(javaResource: Resource): ResourcePolicy = ResourcePolicy(
        javaResource as
            com.pulumi.aws.organizations.ResourcePolicy,
    )
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourcePolicy].
 */
public suspend fun resourcePolicy(
    name: String,
    block: suspend ResourcePolicyResourceBuilder.() -> Unit,
): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourcePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourcePolicy(name: String): ResourcePolicy {
    val builder = ResourcePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
