@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin

import com.pulumi.aws.organizations.ResourcePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a resource-based delegation policy that can be used to delegate policy management for AWS Organizations to specified member accounts to perform policy actions that are by default available only to the management account. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_delegate_policies.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.ResourcePolicy("example", {content: `{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.ResourcePolicy("example", content="""{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.ResourcePolicy("example", new()
 *     {
 *         Content = @"{
 *   ""Version"": ""2012-10-17"",
 *   ""Statement"": [
 *     {
 *       ""Sid"": ""DelegatingNecessaryDescribeListActions"",
 *       ""Effect"": ""Allow"",
 *       ""Principal"": {
 *         ""AWS"": ""arn:aws:iam::123456789012:root""
 *       },
 *       ""Action"": [
 *         ""organizations:DescribeOrganization"",
 *         ""organizations:DescribeOrganizationalUnit"",
 *         ""organizations:DescribeAccount"",
 *         ""organizations:DescribePolicy"",
 *         ""organizations:DescribeEffectivePolicy"",
 *         ""organizations:ListRoots"",
 *         ""organizations:ListOrganizationalUnitsForParent"",
 *         ""organizations:ListParents"",
 *         ""organizations:ListChildren"",
 *         ""organizations:ListAccounts"",
 *         ""organizations:ListAccountsForParent"",
 *         ""organizations:ListPolicies"",
 *         ""organizations:ListPoliciesForTarget"",
 *         ""organizations:ListTargetsForPolicy"",
 *         ""organizations:ListTagsForResource""
 *       ],
 *       ""Resource"": ""*""
 *     }
 *   ]
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := organizations.NewResourcePolicy(ctx, "example", &organizations.ResourcePolicyArgs{
 * 			Content: pulumi.String(`{
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.ResourcePolicy;
 * import com.pulumi.aws.organizations.ResourcePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourcePolicy("example", ResourcePolicyArgs.builder()
 *             .content("""
 * {
 *   "Version": "2012-10-17",
 *   "Statement": [
 *     {
 *       "Sid": "DelegatingNecessaryDescribeListActions",
 *       "Effect": "Allow",
 *       "Principal": {
 *         "AWS": "arn:aws:iam::123456789012:root"
 *       },
 *       "Action": [
 *         "organizations:DescribeOrganization",
 *         "organizations:DescribeOrganizationalUnit",
 *         "organizations:DescribeAccount",
 *         "organizations:DescribePolicy",
 *         "organizations:DescribeEffectivePolicy",
 *         "organizations:ListRoots",
 *         "organizations:ListOrganizationalUnitsForParent",
 *         "organizations:ListParents",
 *         "organizations:ListChildren",
 *         "organizations:ListAccounts",
 *         "organizations:ListAccountsForParent",
 *         "organizations:ListPolicies",
 *         "organizations:ListPoliciesForTarget",
 *         "organizations:ListTargetsForPolicy",
 *         "organizations:ListTagsForResource"
 *       ],
 *       "Resource": "*"
 *     }
 *   ]
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:ResourcePolicy
 *     properties:
 *       content: |
 *         {
 *           "Version": "2012-10-17",
 *           "Statement": [
 *             {
 *               "Sid": "DelegatingNecessaryDescribeListActions",
 *               "Effect": "Allow",
 *               "Principal": {
 *                 "AWS": "arn:aws:iam::123456789012:root"
 *               },
 *               "Action": [
 *                 "organizations:DescribeOrganization",
 *                 "organizations:DescribeOrganizationalUnit",
 *                 "organizations:DescribeAccount",
 *                 "organizations:DescribePolicy",
 *                 "organizations:DescribeEffectivePolicy",
 *                 "organizations:ListRoots",
 *                 "organizations:ListOrganizationalUnitsForParent",
 *                 "organizations:ListParents",
 *                 "organizations:ListChildren",
 *                 "organizations:ListAccounts",
 *                 "organizations:ListAccountsForParent",
 *                 "organizations:ListPolicies",
 *                 "organizations:ListPoliciesForTarget",
 *                 "organizations:ListTargetsForPolicy",
 *                 "organizations:ListTagsForResource"
 *               ],
 *               "Resource": "*"
 *             }
 *           ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_organizations_resource_policy` using the resource policy ID. For example:
 * ```sh
 * $ pulumi import aws:organizations/resourcePolicy:ResourcePolicy example rp-12345678
 * ```
 * @property content Content for the resource policy. The text must be correctly formatted JSON that complies with the syntax for the resource policy's type. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_delegate_examples.html) for examples.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ResourcePolicyArgs(
    public val content: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.ResourcePolicyArgs> {
    override fun toJava(): com.pulumi.aws.organizations.ResourcePolicyArgs =
        com.pulumi.aws.organizations.ResourcePolicyArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourcePolicyArgs].
 */
@PulumiTagMarker
public class ResourcePolicyArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Content for the resource policy. The text must be correctly formatted JSON that complies with the syntax for the resource policy's type. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_delegate_examples.html) for examples.
     */
    @JvmName("xhxcdgyaodbrqswv")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sedduqkbyjodqoir")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Content for the resource policy. The text must be correctly formatted JSON that complies with the syntax for the resource policy's type. See the [_AWS Organizations User Guide_](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_delegate_examples.html) for examples.
     */
    @JvmName("huogkphfofyiguer")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwxiuccetdvfrecd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qekakmnklcaxrvgv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourcePolicyArgs = ResourcePolicyArgs(
        content = content,
        tags = tags,
    )
}
