@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetDelegatedAdministratorsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDelegatedAdministrators.
 * @property servicePrincipal Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service. If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.
 */
public data class GetDelegatedAdministratorsPlainArgs(
    public val servicePrincipal: String? = null,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetDelegatedAdministratorsPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetDelegatedAdministratorsPlainArgs =
        com.pulumi.aws.organizations.inputs.GetDelegatedAdministratorsPlainArgs.builder()
            .servicePrincipal(servicePrincipal?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDelegatedAdministratorsPlainArgs].
 */
@PulumiTagMarker
public class GetDelegatedAdministratorsPlainArgsBuilder internal constructor() {
    private var servicePrincipal: String? = null

    /**
     * @param value Specifies a service principal name. If specified, then the operation lists the delegated administrators only for the specified service. If you don't specify a service principal, the operation lists all delegated administrators for all services in your organization.
     */
    @JvmName("dyuodlgdbwvmevyd")
    public suspend fun servicePrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.servicePrincipal = mapped
    }

    internal fun build(): GetDelegatedAdministratorsPlainArgs = GetDelegatedAdministratorsPlainArgs(
        servicePrincipal = servicePrincipal,
    )
}
