@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetDelegatedServicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDelegatedServices.
 * @property accountId Account ID number of a delegated administrator account in the organization.
 */
public data class GetDelegatedServicesPlainArgs(
    public val accountId: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetDelegatedServicesPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetDelegatedServicesPlainArgs =
        com.pulumi.aws.organizations.inputs.GetDelegatedServicesPlainArgs.builder()
            .accountId(accountId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDelegatedServicesPlainArgs].
 */
@PulumiTagMarker
public class GetDelegatedServicesPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    /**
     * @param value Account ID number of a delegated administrator account in the organization.
     */
    @JvmName("iejvjvscdjmwkydh")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountId = mapped
    }

    internal fun build(): GetDelegatedServicesPlainArgs = GetDelegatedServicesPlainArgs(
        accountId = accountId ?: throw PulumiNullFieldException("accountId"),
    )
}
