@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitDescendantAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrganizationalUnitDescendantAccounts.
 * @property parentId The parent ID of the accounts.
 */
public data class GetOrganizationalUnitDescendantAccountsPlainArgs(
    public val parentId: String,
) :
    ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetOrganizationalUnitDescendantAccountsPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetOrganizationalUnitDescendantAccountsPlainArgs =
        com.pulumi.aws.organizations.inputs.GetOrganizationalUnitDescendantAccountsPlainArgs.builder()
            .parentId(parentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationalUnitDescendantAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationalUnitDescendantAccountsPlainArgsBuilder internal constructor() {
    private var parentId: String? = null

    /**
     * @param value The parent ID of the accounts.
     */
    @JvmName("iimseuhiloigalet")
    public suspend fun parentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentId = mapped
    }

    internal fun build(): GetOrganizationalUnitDescendantAccountsPlainArgs =
        GetOrganizationalUnitDescendantAccountsPlainArgs(
            parentId = parentId ?: throw PulumiNullFieldException("parentId"),
        )
}
