@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetOrganizationalUnitPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrganizationalUnit.
 * @property name Name of the organizational unit
 * @property parentId Parent ID of the organizational unit.
 */
public data class GetOrganizationalUnitPlainArgs(
    public val name: String,
    public val parentId: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetOrganizationalUnitPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetOrganizationalUnitPlainArgs =
        com.pulumi.aws.organizations.inputs.GetOrganizationalUnitPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .parentId(parentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationalUnitPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationalUnitPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var parentId: String? = null

    /**
     * @param value Name of the organizational unit
     */
    @JvmName("rkgkxnlbrvvtuxpb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Parent ID of the organizational unit.
     */
    @JvmName("yselisfrfogervgq")
    public suspend fun parentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentId = mapped
    }

    internal fun build(): GetOrganizationalUnitPlainArgs = GetOrganizationalUnitPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        parentId = parentId ?: throw PulumiNullFieldException("parentId"),
    )
}
