@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetPoliciesForTargetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPoliciesForTarget.
 * @property filter Must supply one of the 4 different policy filters for a target (SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY)
 * @property targetId The root (string that begins with "r-" followed by 4-32 lowercase letters or digits), account (12 digit string), or Organizational Unit (string starting with "ou-" followed by 4-32 lowercase letters or digits. This string is followed by a second "-" dash and from 8-32 additional lowercase letters or digits.)
 */
public data class GetPoliciesForTargetPlainArgs(
    public val filter: String,
    public val targetId: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetPoliciesForTargetPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetPoliciesForTargetPlainArgs =
        com.pulumi.aws.organizations.inputs.GetPoliciesForTargetPlainArgs.builder()
            .filter(filter.let({ args0 -> args0 }))
            .targetId(targetId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoliciesForTargetPlainArgs].
 */
@PulumiTagMarker
public class GetPoliciesForTargetPlainArgsBuilder internal constructor() {
    private var filter: String? = null

    private var targetId: String? = null

    /**
     * @param value Must supply one of the 4 different policy filters for a target (SERVICE_CONTROL_POLICY | TAG_POLICY | BACKUP_POLICY | AISERVICES_OPT_OUT_POLICY)
     */
    @JvmName("udobkdboxbnjenaq")
    public suspend fun filter(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value The root (string that begins with "r-" followed by 4-32 lowercase letters or digits), account (12 digit string), or Organizational Unit (string starting with "ou-" followed by 4-32 lowercase letters or digits. This string is followed by a second "-" dash and from 8-32 additional lowercase letters or digits.)
     */
    @JvmName("baboebokqecgcmxv")
    public suspend fun targetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetId = mapped
    }

    internal fun build(): GetPoliciesForTargetPlainArgs = GetPoliciesForTargetPlainArgs(
        filter = filter ?: throw PulumiNullFieldException("filter"),
        targetId = targetId ?: throw PulumiNullFieldException("targetId"),
    )
}
