@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.inputs

import com.pulumi.aws.organizations.inputs.GetPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicy.
 * @property policyId The unique identifier (ID) of the policy that you want more details on. Policy id starts with a "p-" followed by 8-28 lowercase or uppercase letters, digits, and underscores.
 */
public data class GetPolicyPlainArgs(
    public val policyId: String,
) : ConvertibleToJava<com.pulumi.aws.organizations.inputs.GetPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.organizations.inputs.GetPolicyPlainArgs =
        com.pulumi.aws.organizations.inputs.GetPolicyPlainArgs.builder()
            .policyId(policyId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyPlainArgsBuilder internal constructor() {
    private var policyId: String? = null

    /**
     * @param value The unique identifier (ID) of the policy that you want more details on. Policy id starts with a "p-" followed by 8-28 lowercase or uppercase letters, digits, and underscores.
     */
    @JvmName("thcldxgmotrrewoe")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyId = mapped
    }

    internal fun build(): GetPolicyPlainArgs = GetPolicyPlainArgs(
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
    )
}
