@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The ARN of the delegated administrator's account.
 * @property delegationEnabledDate The date when the account was made a delegated administrator.
 * @property email The email address that is associated with the delegated administrator's AWS account.
 * @property id The unique identifier (ID) of the delegated administrator's account.
 * @property joinedMethod The method by which the delegated administrator's account joined the organization.
 * @property joinedTimestamp The date when the delegated administrator's account became a part of the organization.
 * @property name The friendly name of the delegated administrator's account.
 * @property status The status of the delegated administrator's account in the organization.
 */
public data class GetDelegatedAdministratorsDelegatedAdministrator(
    public val arn: String,
    public val delegationEnabledDate: String,
    public val email: String,
    public val id: String,
    public val joinedMethod: String,
    public val joinedTimestamp: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetDelegatedAdministratorsDelegatedAdministrator): GetDelegatedAdministratorsDelegatedAdministrator =
            GetDelegatedAdministratorsDelegatedAdministrator(
                arn = javaType.arn(),
                delegationEnabledDate = javaType.delegationEnabledDate(),
                email = javaType.email(),
                id = javaType.id(),
                joinedMethod = javaType.joinedMethod(),
                joinedTimestamp = javaType.joinedTimestamp(),
                name = javaType.name(),
                status = javaType.status(),
            )
    }
}
