@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDelegatedAdministrators.
 * @property delegatedAdministrators The list of delegated administrators in your organization, which have the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property servicePrincipal
 */
public data class GetDelegatedAdministratorsResult(
    public val delegatedAdministrators: List<GetDelegatedAdministratorsDelegatedAdministrator>,
    public val id: String,
    public val servicePrincipal: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetDelegatedAdministratorsResult): GetDelegatedAdministratorsResult = GetDelegatedAdministratorsResult(
            delegatedAdministrators = javaType.delegatedAdministrators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.organizations.kotlin.outputs.GetDelegatedAdministratorsDelegatedAdministrator.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            servicePrincipal = javaType.servicePrincipal().map({ args0 -> args0 }).orElse(null),
        )
    }
}
