@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the account.
 * @property email The email address associated with the AWS account.
 * @property id Parent identifier of the organizational units.
 * @property name The friendly name of the account.
 * @property status The status of the account in the organization.
 */
public data class GetOrganizationalUnitChildAccountsAccount(
    public val arn: String,
    public val email: String,
    public val id: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationalUnitChildAccountsAccount): GetOrganizationalUnitChildAccountsAccount = GetOrganizationalUnitChildAccountsAccount(
            arn = javaType.arn(),
            email = javaType.email(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
