@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOrganizationalUnitDescendantAccounts.
 * @property accounts List of child accounts, which have the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property parentId
 */
public data class GetOrganizationalUnitDescendantAccountsResult(
    public val accounts: List<GetOrganizationalUnitDescendantAccountsAccount>,
    public val id: String,
    public val parentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetOrganizationalUnitDescendantAccountsResult): GetOrganizationalUnitDescendantAccountsResult =
            GetOrganizationalUnitDescendantAccountsResult(
                accounts = javaType.accounts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.organizations.kotlin.outputs.GetOrganizationalUnitDescendantAccountsAccount.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                parentId = javaType.parentId(),
            )
    }
}
