@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicies.
 * @property filter
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of all the policy ids found.
 */
public data class GetPoliciesResult(
    public val filter: String,
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetPoliciesResult): GetPoliciesResult = GetPoliciesResult(
            filter = javaType.filter(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
        )
    }
}
