@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getResourceTags.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property resourceId
 * @property tags Map of key=value pairs for each tag set on the resource.
 */
public data class GetResourceTagsResult(
    public val id: String,
    public val resourceId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.GetResourceTagsResult): GetResourceTagsResult = GetResourceTagsResult(
            id = javaType.id(),
            resourceId = javaType.resourceId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
