@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.organizations.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the root
 * @property email Email of the account
 * @property id Identifier of the root
 * @property name The name of the policy type
 * @property status The status of the policy type as it relates to the associated root
 */
public data class OrganizationNonMasterAccount(
    public val arn: String? = null,
    public val email: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.organizations.outputs.OrganizationNonMasterAccount): OrganizationNonMasterAccount = OrganizationNonMasterAccount(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
