@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin

import com.pulumi.aws.outposts.OutpostsFunctions.getAssetPlain
import com.pulumi.aws.outposts.OutpostsFunctions.getAssetsPlain
import com.pulumi.aws.outposts.OutpostsFunctions.getOutpostInstanceTypePlain
import com.pulumi.aws.outposts.OutpostsFunctions.getOutpostInstanceTypesPlain
import com.pulumi.aws.outposts.OutpostsFunctions.getOutpostPlain
import com.pulumi.aws.outposts.OutpostsFunctions.getOutpostsPlain
import com.pulumi.aws.outposts.OutpostsFunctions.getSitePlain
import com.pulumi.aws.outposts.OutpostsFunctions.getSitesPlain
import com.pulumi.aws.outposts.kotlin.inputs.GetAssetPlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetAssetPlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetAssetsPlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetAssetsPlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostInstanceTypePlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostInstanceTypePlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostInstanceTypesPlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostInstanceTypesPlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostPlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostPlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostsPlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetOutpostsPlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.inputs.GetSitePlainArgs
import com.pulumi.aws.outposts.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.aws.outposts.kotlin.outputs.GetAssetResult
import com.pulumi.aws.outposts.kotlin.outputs.GetAssetsResult
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostInstanceTypeResult
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostInstanceTypesResult
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostResult
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostsResult
import com.pulumi.aws.outposts.kotlin.outputs.GetSiteResult
import com.pulumi.aws.outposts.kotlin.outputs.GetSitesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.outposts.kotlin.outputs.GetAssetResult.Companion.toKotlin as getAssetResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetAssetsResult.Companion.toKotlin as getAssetsResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostInstanceTypeResult.Companion.toKotlin as getOutpostInstanceTypeResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostInstanceTypesResult.Companion.toKotlin as getOutpostInstanceTypesResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostResult.Companion.toKotlin as getOutpostResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetOutpostsResult.Companion.toKotlin as getOutpostsResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.aws.outposts.kotlin.outputs.GetSitesResult.Companion.toKotlin as getSitesResultToKotlin

public object OutpostsFunctions {
    /**
     * Information about a specific hardware asset in an Outpost.
     * @param argument A collection of arguments for invoking getAsset.
     * @return A collection of values returned by getAsset.
     */
    public suspend fun getAsset(argument: GetAssetPlainArgs): GetAssetResult =
        getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())

    /**
     * @see [getAsset].
     * @param arn Outpost ARN.
     * @param assetId ID of the asset.
     * @return A collection of values returned by getAsset.
     */
    public suspend fun getAsset(arn: String, assetId: String): GetAssetResult {
        val argument = GetAssetPlainArgs(
            arn = arn,
            assetId = assetId,
        )
        return getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())
    }

    /**
     * @see [getAsset].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetAssetPlainArgs].
     * @return A collection of values returned by getAsset.
     */
    public suspend fun getAsset(argument: suspend GetAssetPlainArgsBuilder.() -> Unit): GetAssetResult {
        val builder = GetAssetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetResultToKotlin(getAssetPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about hardware assets in an Outpost.
     * ## Example Usage
     * ### Basic
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getAssets({
     *     arn: exampleAwsOutpostsOutpost.arn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_assets(arn=example_aws_outposts_outpost["arn"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetAssets.Invoke(new()
     *     {
     *         Arn = exampleAwsOutpostsOutpost.Arn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetAssets(ctx, &outposts.GetAssetsArgs{
     * 			Arn: exampleAwsOutpostsOutpost.Arn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetAssetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getAssets(GetAssetsArgs.builder()
     *             .arn(exampleAwsOutpostsOutpost.arn())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getAssets
     *       Arguments:
     *         arn: ${exampleAwsOutpostsOutpost.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With Host ID Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getAssets({
     *     arn: exampleAwsOutpostsOutpost.arn,
     *     hostIdFilters: ["h-x38g5n0yd2a0ueb61"],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_assets(arn=example_aws_outposts_outpost["arn"],
     *     host_id_filters=["h-x38g5n0yd2a0ueb61"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetAssets.Invoke(new()
     *     {
     *         Arn = exampleAwsOutpostsOutpost.Arn,
     *         HostIdFilters = new[]
     *         {
     *             "h-x38g5n0yd2a0ueb61",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetAssets(ctx, &outposts.GetAssetsArgs{
     * 			Arn: exampleAwsOutpostsOutpost.Arn,
     * 			HostIdFilters: []string{
     * 				"h-x38g5n0yd2a0ueb61",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetAssetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getAssets(GetAssetsArgs.builder()
     *             .arn(exampleAwsOutpostsOutpost.arn())
     *             .hostIdFilters("h-x38g5n0yd2a0ueb61")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getAssets
     *       Arguments:
     *         arn: ${exampleAwsOutpostsOutpost.arn}
     *         hostIdFilters:
     *           - h-x38g5n0yd2a0ueb61
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With Status ID Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getAssets({
     *     arn: exampleAwsOutpostsOutpost.arn,
     *     statusIdFilters: ["ACTIVE"],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_assets(arn=example_aws_outposts_outpost["arn"],
     *     status_id_filters=["ACTIVE"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetAssets.Invoke(new()
     *     {
     *         Arn = exampleAwsOutpostsOutpost.Arn,
     *         StatusIdFilters = new[]
     *         {
     *             "ACTIVE",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetAssets(ctx, &outposts.GetAssetsArgs{
     * 			Arn: exampleAwsOutpostsOutpost.Arn,
     * 			StatusIdFilters: []string{
     * 				"ACTIVE",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetAssetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getAssets(GetAssetsArgs.builder()
     *             .arn(exampleAwsOutpostsOutpost.arn())
     *             .statusIdFilters("ACTIVE")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getAssets
     *       Arguments:
     *         arn: ${exampleAwsOutpostsOutpost.arn}
     *         statusIdFilters:
     *           - ACTIVE
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAssets.
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(argument: GetAssetsPlainArgs): GetAssetsResult =
        getAssetsResultToKotlin(getAssetsPlain(argument.toJava()).await())

    /**
     * @see [getAssets].
     * @param arn Outpost ARN.
     * @param hostIdFilters Filters by list of Host IDs of a Dedicated Host.
     * @param statusIdFilters Filters by list of state status. Valid values: "ACTIVE", "RETIRING".
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(
        arn: String,
        hostIdFilters: List<String>? = null,
        statusIdFilters: List<String>? = null,
    ): GetAssetsResult {
        val argument = GetAssetsPlainArgs(
            arn = arn,
            hostIdFilters = hostIdFilters,
            statusIdFilters = statusIdFilters,
        )
        return getAssetsResultToKotlin(getAssetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetAssetsPlainArgs].
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(argument: suspend GetAssetsPlainArgsBuilder.() -> Unit): GetAssetsResult {
        val builder = GetAssetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetsResultToKotlin(getAssetsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Outposts Outpost.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getOutpost({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_outpost(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetOutpost.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetOutpost(ctx, &outposts.GetOutpostArgs{
     * 			Name: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetOutpostArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getOutpost(GetOutpostArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getOutpost
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOutpost.
     * @return A collection of values returned by getOutpost.
     */
    public suspend fun getOutpost(argument: GetOutpostPlainArgs): GetOutpostResult =
        getOutpostResultToKotlin(getOutpostPlain(argument.toJava()).await())

    /**
     * @see [getOutpost].
     * @param arn ARN.
     * @param id Identifier of the Outpost.
     * @param name Name of the Outpost.
     * @param ownerId AWS Account identifier of the Outpost owner.
     * @param tags The Outpost tags.
     * @return A collection of values returned by getOutpost.
     */
    public suspend fun getOutpost(
        arn: String? = null,
        id: String? = null,
        name: String? = null,
        ownerId: String? = null,
        tags: Map<String, String>? = null,
    ): GetOutpostResult {
        val argument = GetOutpostPlainArgs(
            arn = arn,
            id = id,
            name = name,
            ownerId = ownerId,
            tags = tags,
        )
        return getOutpostResultToKotlin(getOutpostPlain(argument.toJava()).await())
    }

    /**
     * @see [getOutpost].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetOutpostPlainArgs].
     * @return A collection of values returned by getOutpost.
     */
    public suspend fun getOutpost(argument: suspend GetOutpostPlainArgsBuilder.() -> Unit): GetOutpostResult {
        val builder = GetOutpostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOutpostResultToKotlin(getOutpostPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about single Outpost Instance Type.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getOutpostInstanceType({
     *     arn: exampleAwsOutpostsOutpost.arn,
     *     preferredInstanceTypes: [
     *         "m5.large",
     *         "m5.4xlarge",
     *     ],
     * });
     * const exampleEc2Instance = new aws.index.Ec2Instance("example", {instanceType: example.instanceType});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_outpost_instance_type(arn=example_aws_outposts_outpost["arn"],
     *     preferred_instance_types=[
     *         "m5.large",
     *         "m5.4xlarge",
     *     ])
     * example_ec2_instance = aws.index.Ec2Instance("example", instance_type=example.instance_type)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetOutpostInstanceType.Invoke(new()
     *     {
     *         Arn = exampleAwsOutpostsOutpost.Arn,
     *         PreferredInstanceTypes = new[]
     *         {
     *             "m5.large",
     *             "m5.4xlarge",
     *         },
     *     });
     *     var exampleEc2Instance = new Aws.Index.Ec2Instance("example", new()
     *     {
     *         InstanceType = example.Apply(getOutpostInstanceTypeResult => getOutpostInstanceTypeResult.InstanceType),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := outposts.GetOutpostInstanceType(ctx, &outposts.GetOutpostInstanceTypeArgs{
     * 			Arn: exampleAwsOutpostsOutpost.Arn,
     * 			PreferredInstanceTypes: []string{
     * 				"m5.large",
     * 				"m5.4xlarge",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = aws.NewEc2Instance(ctx, "example", &aws.Ec2InstanceArgs{
     * 			InstanceType: example.InstanceType,
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypeArgs;
     * import com.pulumi.aws.ec2Instance;
     * import com.pulumi.aws.Ec2InstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getOutpostInstanceType(GetOutpostInstanceTypeArgs.builder()
     *             .arn(exampleAwsOutpostsOutpost.arn())
     *             .preferredInstanceTypes(
     *                 "m5.large",
     *                 "m5.4xlarge")
     *             .build());
     *         var exampleEc2Instance = new Ec2Instance("exampleEc2Instance", Ec2InstanceArgs.builder()
     *             .instanceType(example.applyValue(getOutpostInstanceTypeResult -> getOutpostInstanceTypeResult.instanceType()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleEc2Instance:
     *     type: aws:ec2Instance
     *     name: example
     *     properties:
     *       instanceType: ${example.instanceType}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getOutpostInstanceType
     *       Arguments:
     *         arn: ${exampleAwsOutpostsOutpost.arn}
     *         preferredInstanceTypes:
     *           - m5.large
     *           - m5.4xlarge
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOutpostInstanceType.
     * @return A collection of values returned by getOutpostInstanceType.
     */
    public suspend fun getOutpostInstanceType(argument: GetOutpostInstanceTypePlainArgs): GetOutpostInstanceTypeResult =
        getOutpostInstanceTypeResultToKotlin(getOutpostInstanceTypePlain(argument.toJava()).await())

    /**
     * @see [getOutpostInstanceType].
     * @param arn Outpost ARN.
     * The following arguments are optional:
     * @param instanceType Desired instance type. Conflicts with `preferred_instance_types`.
     * @param preferredInstanceTypes Ordered list of preferred instance types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned. Conflicts with `instance_type`.
     * @return A collection of values returned by getOutpostInstanceType.
     */
    public suspend fun getOutpostInstanceType(
        arn: String,
        instanceType: String? = null,
        preferredInstanceTypes: List<String>? = null,
    ): GetOutpostInstanceTypeResult {
        val argument = GetOutpostInstanceTypePlainArgs(
            arn = arn,
            instanceType = instanceType,
            preferredInstanceTypes = preferredInstanceTypes,
        )
        return getOutpostInstanceTypeResultToKotlin(getOutpostInstanceTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getOutpostInstanceType].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetOutpostInstanceTypePlainArgs].
     * @return A collection of values returned by getOutpostInstanceType.
     */
    public suspend fun getOutpostInstanceType(argument: suspend GetOutpostInstanceTypePlainArgsBuilder.() -> Unit): GetOutpostInstanceTypeResult {
        val builder = GetOutpostInstanceTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOutpostInstanceTypeResultToKotlin(getOutpostInstanceTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Information about Outposts Instance Types.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getOutpostInstanceTypes({
     *     arn: exampleAwsOutpostsOutpost.arn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_outpost_instance_types(arn=example_aws_outposts_outpost["arn"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetOutpostInstanceTypes.Invoke(new()
     *     {
     *         Arn = exampleAwsOutpostsOutpost.Arn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetOutpostInstanceTypes(ctx, &outposts.GetOutpostInstanceTypesArgs{
     * 			Arn: exampleAwsOutpostsOutpost.Arn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getOutpostInstanceTypes(GetOutpostInstanceTypesArgs.builder()
     *             .arn(exampleAwsOutpostsOutpost.arn())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getOutpostInstanceTypes
     *       Arguments:
     *         arn: ${exampleAwsOutpostsOutpost.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOutpostInstanceTypes.
     * @return A collection of values returned by getOutpostInstanceTypes.
     */
    public suspend fun getOutpostInstanceTypes(argument: GetOutpostInstanceTypesPlainArgs): GetOutpostInstanceTypesResult =
        getOutpostInstanceTypesResultToKotlin(getOutpostInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getOutpostInstanceTypes].
     * @param arn Outpost ARN.
     * @return A collection of values returned by getOutpostInstanceTypes.
     */
    public suspend fun getOutpostInstanceTypes(arn: String): GetOutpostInstanceTypesResult {
        val argument = GetOutpostInstanceTypesPlainArgs(
            arn = arn,
        )
        return getOutpostInstanceTypesResultToKotlin(getOutpostInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getOutpostInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetOutpostInstanceTypesPlainArgs].
     * @return A collection of values returned by getOutpostInstanceTypes.
     */
    public suspend fun getOutpostInstanceTypes(argument: suspend GetOutpostInstanceTypesPlainArgsBuilder.() -> Unit): GetOutpostInstanceTypesResult {
        val builder = GetOutpostInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOutpostInstanceTypesResultToKotlin(getOutpostInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple Outposts.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getOutposts({
     *     siteId: id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_outposts(site_id=id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetOutposts.Invoke(new()
     *     {
     *         SiteId = id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetOutposts(ctx, &outposts.GetOutpostsArgs{
     * 			SiteId: pulumi.StringRef(id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetOutpostsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getOutposts(GetOutpostsArgs.builder()
     *             .siteId(id)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getOutposts
     *       Arguments:
     *         siteId: ${id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOutposts.
     * @return A collection of values returned by getOutposts.
     */
    public suspend fun getOutposts(argument: GetOutpostsPlainArgs): GetOutpostsResult =
        getOutpostsResultToKotlin(getOutpostsPlain(argument.toJava()).await())

    /**
     * @see [getOutposts].
     * @param availabilityZone Availability Zone name.
     * @param availabilityZoneId Availability Zone identifier.
     * @param ownerId AWS Account identifier of the Outpost owner.
     * @param siteId Site identifier.
     * @return A collection of values returned by getOutposts.
     */
    public suspend fun getOutposts(
        availabilityZone: String? = null,
        availabilityZoneId: String? = null,
        ownerId: String? = null,
        siteId: String? = null,
    ): GetOutpostsResult {
        val argument = GetOutpostsPlainArgs(
            availabilityZone = availabilityZone,
            availabilityZoneId = availabilityZoneId,
            ownerId = ownerId,
            siteId = siteId,
        )
        return getOutpostsResultToKotlin(getOutpostsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOutposts].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetOutpostsPlainArgs].
     * @return A collection of values returned by getOutposts.
     */
    public suspend fun getOutposts(argument: suspend GetOutpostsPlainArgsBuilder.() -> Unit): GetOutpostsResult {
        val builder = GetOutpostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOutpostsResultToKotlin(getOutpostsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Outposts Site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.outposts.getSite({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.outposts.get_site(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Outposts.GetSite.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetSite(ctx, &outposts.GetSiteArgs{
     * 			Name: pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import com.pulumi.aws.outposts.inputs.GetSiteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = OutpostsFunctions.getSite(GetSiteArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:outposts:getSite
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSite.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param id Identifier of the Site.
     * @param name Name of the Site.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(id: String? = null, name: String? = null): GetSiteResult {
        val argument = GetSitePlainArgs(
            id = id,
            name = name,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;outposts&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple Outposts Sites.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const all = aws.outposts.getSites({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * all = aws.outposts.get_sites()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = Aws.Outposts.GetSites.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetSites(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = OutpostsFunctions.getSites();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: aws:outposts:getSites
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Provides details about multiple Outposts Sites.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const all = aws.outposts.getSites({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * all = aws.outposts.get_sites()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = Aws.Outposts.GetSites.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/outposts"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := outposts.GetSites(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.outposts.OutpostsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = OutpostsFunctions.getSites();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: aws:outposts:getSites
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(): GetSitesResult = getSitesResultToKotlin(getSitesPlain().await())
}
