@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOutpostInstanceTypes.
 * @property arn Outpost ARN.
 */
public data class GetOutpostInstanceTypesPlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypesPlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypesPlainArgs =
        com.pulumi.aws.outposts.inputs.GetOutpostInstanceTypesPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOutpostInstanceTypesPlainArgs].
 */
@PulumiTagMarker
public class GetOutpostInstanceTypesPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value Outpost ARN.
     */
    @JvmName("lpmcskeootcqqbke")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetOutpostInstanceTypesPlainArgs = GetOutpostInstanceTypesPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
