@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.inputs

import com.pulumi.aws.outposts.inputs.GetOutpostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOutposts.
 * @property availabilityZone Availability Zone name.
 * @property availabilityZoneId Availability Zone identifier.
 * @property ownerId AWS Account identifier of the Outpost owner.
 * @property siteId Site identifier.
 */
public data class GetOutpostsPlainArgs(
    public val availabilityZone: String? = null,
    public val availabilityZoneId: String? = null,
    public val ownerId: String? = null,
    public val siteId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.outposts.inputs.GetOutpostsPlainArgs> {
    override fun toJava(): com.pulumi.aws.outposts.inputs.GetOutpostsPlainArgs =
        com.pulumi.aws.outposts.inputs.GetOutpostsPlainArgs.builder()
            .availabilityZone(availabilityZone?.let({ args0 -> args0 }))
            .availabilityZoneId(availabilityZoneId?.let({ args0 -> args0 }))
            .ownerId(ownerId?.let({ args0 -> args0 }))
            .siteId(siteId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOutpostsPlainArgs].
 */
@PulumiTagMarker
public class GetOutpostsPlainArgsBuilder internal constructor() {
    private var availabilityZone: String? = null

    private var availabilityZoneId: String? = null

    private var ownerId: String? = null

    private var siteId: String? = null

    /**
     * @param value Availability Zone name.
     */
    @JvmName("lenwruxsbjmsatnj")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZone = mapped
    }

    /**
     * @param value Availability Zone identifier.
     */
    @JvmName("wlbqgddjtesoldca")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value AWS Account identifier of the Outpost owner.
     */
    @JvmName("valtbrrqsungqoej")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ownerId = mapped
    }

    /**
     * @param value Site identifier.
     */
    @JvmName("tjxnafswowcmajtq")
    public suspend fun siteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.siteId = mapped
    }

    internal fun build(): GetOutpostsPlainArgs = GetOutpostsPlainArgs(
        availabilityZone = availabilityZone,
        availabilityZoneId = availabilityZoneId,
        ownerId = ownerId,
        siteId = siteId,
    )
}
