@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAsset.
 * @property arn
 * @property assetId
 * @property assetType Type of the asset.
 * @property hostId Host ID of the Dedicated Hosts on the asset, if a Dedicated Host is provisioned.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property rackElevation Position of an asset in a rack measured in rack units.
 * @property rackId Rack ID of the asset.
 */
public data class GetAssetResult(
    public val arn: String,
    public val assetId: String,
    public val assetType: String,
    public val hostId: String,
    public val id: String,
    public val rackElevation: Int,
    public val rackId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetAssetResult): GetAssetResult =
            GetAssetResult(
                arn = javaType.arn(),
                assetId = javaType.assetId(),
                assetType = javaType.assetType(),
                hostId = javaType.hostId(),
                id = javaType.id(),
                rackElevation = javaType.rackElevation(),
                rackId = javaType.rackId(),
            )
    }
}
