@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAssets.
 * @property arn
 * @property assetIds List of all the asset ids found. This data source will fail if none are found.
 * @property hostIdFilters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property statusIdFilters
 */
public data class GetAssetsResult(
    public val arn: String,
    public val assetIds: List<String>,
    public val hostIdFilters: List<String>? = null,
    public val id: String,
    public val statusIdFilters: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetAssetsResult): GetAssetsResult = GetAssetsResult(
            arn = javaType.arn(),
            assetIds = javaType.assetIds().map({ args0 -> args0 }),
            hostIdFilters = javaType.hostIdFilters().map({ args0 -> args0 }),
            id = javaType.id(),
            statusIdFilters = javaType.statusIdFilters().map({ args0 -> args0 }),
        )
    }
}
