@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOutpostInstanceType.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceType
 * @property preferredInstanceTypes
 */
public data class GetOutpostInstanceTypeResult(
    public val arn: String,
    public val id: String,
    public val instanceType: String,
    public val preferredInstanceTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetOutpostInstanceTypeResult): GetOutpostInstanceTypeResult = GetOutpostInstanceTypeResult(
            arn = javaType.arn(),
            id = javaType.id(),
            instanceType = javaType.instanceType(),
            preferredInstanceTypes = javaType.preferredInstanceTypes().map({ args0 -> args0 }),
        )
    }
}
