@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOutpostInstanceTypes.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceTypes Set of instance types.
 */
public data class GetOutpostInstanceTypesResult(
    public val arn: String,
    public val id: String,
    public val instanceTypes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetOutpostInstanceTypesResult): GetOutpostInstanceTypesResult = GetOutpostInstanceTypesResult(
            arn = javaType.arn(),
            id = javaType.id(),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
        )
    }
}
