@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOutposts.
 * @property arns Set of Amazon Resource Names (ARNs).
 * @property availabilityZone
 * @property availabilityZoneId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of identifiers.
 * @property ownerId
 * @property siteId
 */
public data class GetOutpostsResult(
    public val arns: List<String>,
    public val availabilityZone: String,
    public val availabilityZoneId: String,
    public val id: String,
    public val ids: List<String>,
    public val ownerId: String,
    public val siteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetOutpostsResult): GetOutpostsResult = GetOutpostsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            availabilityZone = javaType.availabilityZone(),
            availabilityZoneId = javaType.availabilityZoneId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ownerId = javaType.ownerId(),
            siteId = javaType.siteId(),
        )
    }
}
