@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.outposts.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSite.
 * @property accountId AWS Account identifier.
 * @property description Description.
 * @property id
 * @property name
 */
public data class GetSiteResult(
    public val accountId: String,
    public val description: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.outposts.outputs.GetSiteResult): GetSiteResult =
            GetSiteResult(
                accountId = javaType.accountId(),
                description = javaType.description(),
                id = javaType.id(),
                name = javaType.name(),
            )
    }
}
