@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin

import com.pulumi.aws.paymentcryptography.kotlin.outputs.KeyKeyAttributes
import com.pulumi.aws.paymentcryptography.kotlin.outputs.KeyTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.paymentcryptography.kotlin.outputs.KeyKeyAttributes.Companion.toKotlin as keyKeyAttributesToKotlin
import com.pulumi.aws.paymentcryptography.kotlin.outputs.KeyTimeouts.Companion.toKotlin as keyTimeoutsToKotlin

/**
 * Builder for [Key].
 */
@PulumiTagMarker
public class KeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyArgs = KeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyArgsBuilder.() -> Unit) {
        val builder = KeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Key {
        val builtJavaResource = com.pulumi.aws.paymentcryptography.Key(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Key(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Payment Cryptography Control Plane Key.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.paymentcryptography.Key;
 * import com.pulumi.aws.paymentcryptography.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Key("test", KeyArgs.builder()
 *             .exportable(true)
 *             .keyAttributes(KeyKeyAttributesArgs.builder()
 *                 .keyAlgorithm("TDES_3KEY")
 *                 .keyClass("SYMMETRIC_KEY")
 *                 .keyUsage("TR31_P0_PIN_ENCRYPTION_KEY")
 *                 .keyModesOfUse(KeyKeyAttributesKeyModesOfUseArgs.builder()
 *                     .decrypt(true)
 *                     .encrypt(true)
 *                     .wrap(true)
 *                     .unwrap(true)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:paymentcryptography:Key
 *     properties:
 *       exportable: true
 *       keyAttributes:
 *         - keyAlgorithm: TDES_3KEY
 *           keyClass: SYMMETRIC_KEY
 *           keyUsage: TR31_P0_PIN_ENCRYPTION_KEY
 *           keyModesOfUse:
 *             - decrypt: true
 *               encrypt: true
 *               wrap: true
 *               unwrap: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Payment Cryptography Control Plane Key using the `arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf`. For example:
 * ```sh
 * $ pulumi import aws:paymentcryptography/key:Key example arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf
 * ```
 */
public class Key internal constructor(
    override val javaResource: com.pulumi.aws.paymentcryptography.Key,
) : KotlinCustomResource(javaResource, KeyMapper) {
    /**
     * ARN of the key.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val deletionWindowInDays: Output<Int>
        get() = javaResource.deletionWindowInDays().applyValue({ args0 -> args0 })

    /**
     * Whether to enable the key.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Whether the key is exportable from the service.
     */
    public val exportable: Output<Boolean>
        get() = javaResource.exportable().applyValue({ args0 -> args0 })

    /**
     * Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * The following arguments are optional:
     */
    public val keyAttributes: Output<KeyKeyAttributes>?
        get() = javaResource.keyAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyKeyAttributesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.
     */
    public val keyCheckValue: Output<String>
        get() = javaResource.keyCheckValue().applyValue({ args0 -> args0 })

    /**
     * Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     */
    public val keyCheckValueAlgorithm: Output<String>
        get() = javaResource.keyCheckValueAlgorithm().applyValue({ args0 -> args0 })

    /**
     * Source of the key material.
     */
    public val keyOrigin: Output<String>
        get() = javaResource.keyOrigin().applyValue({ args0 -> args0 })

    /**
     * State of key that is being created or deleted.
     */
    public val keyState: Output<String>
        get() = javaResource.keyState().applyValue({ args0 -> args0 })

    /**
     * Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<KeyTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keyTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object KeyMapper : ResourceMapper<Key> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.paymentcryptography.Key::class == javaResource::class

    override fun map(javaResource: Resource): Key = Key(
        javaResource as
            com.pulumi.aws.paymentcryptography.Key,
    )
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Key].
 */
public suspend fun key(name: String, block: suspend KeyResourceBuilder.() -> Unit): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 */
public fun key(name: String): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
