@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyAlias].
 */
@PulumiTagMarker
public class KeyAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyAliasArgs = KeyAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyAliasArgsBuilder.() -> Unit) {
        val builder = KeyAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyAlias {
        val builtJavaResource = com.pulumi.aws.paymentcryptography.KeyAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyAlias(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Payment Cryptography Control Plane Key Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.paymentcryptography.Key;
 * import com.pulumi.aws.paymentcryptography.KeyArgs;
 * import com.pulumi.aws.paymentcryptography.KeyAlias;
 * import com.pulumi.aws.paymentcryptography.KeyAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Key("test", KeyArgs.builder()
 *             .exportable(true)
 *             .keyAttributes(KeyKeyAttributesArgs.builder()
 *                 .keyAlgorithm("TDES_3KEY")
 *                 .keyClass("SYMMETRIC_KEY")
 *                 .keyUsage("TR31_P0_PIN_ENCRYPTION_KEY")
 *                 .keyModesOfUse(KeyKeyAttributesKeyModesOfUseArgs.builder()
 *                     .decrypt(true)
 *                     .encrypt(true)
 *                     .wrap(true)
 *                     .unwrap(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         var testKeyAlias = new KeyAlias("testKeyAlias", KeyAliasArgs.builder()
 *             .aliasName("alias/test-alias")
 *             .keyArn(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:paymentcryptography:Key
 *     properties:
 *       exportable: true
 *       keyAttributes:
 *         - keyAlgorithm: TDES_3KEY
 *           keyClass: SYMMETRIC_KEY
 *           keyUsage: TR31_P0_PIN_ENCRYPTION_KEY
 *           keyModesOfUse:
 *             - decrypt: true
 *               encrypt: true
 *               wrap: true
 *               unwrap: true
 *   testKeyAlias:
 *     type: aws:paymentcryptography:KeyAlias
 *     name: test
 *     properties:
 *       aliasName: alias/test-alias
 *       keyArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:
 * ```sh
 * $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
 * ```
 */
public class KeyAlias internal constructor(
    override val javaResource: com.pulumi.aws.paymentcryptography.KeyAlias,
) : KotlinCustomResource(javaResource, KeyAliasMapper) {
    /**
     * Name of the Key Alias.
     * The following arguments are optional:
     */
    public val aliasName: Output<String>
        get() = javaResource.aliasName().applyValue({ args0 -> args0 })

    /**
     * ARN of the key.
     */
    public val keyArn: Output<String>?
        get() = javaResource.keyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object KeyAliasMapper : ResourceMapper<KeyAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.paymentcryptography.KeyAlias::class == javaResource::class

    override fun map(javaResource: Resource): KeyAlias = KeyAlias(
        javaResource as
            com.pulumi.aws.paymentcryptography.KeyAlias,
    )
}

/**
 * @see [KeyAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyAlias].
 */
public suspend fun keyAlias(name: String, block: suspend KeyAliasResourceBuilder.() -> Unit): KeyAlias {
    val builder = KeyAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyAlias(name: String): KeyAlias {
    val builder = KeyAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
