@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin

import com.pulumi.aws.paymentcryptography.KeyAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Payment Cryptography Control Plane Key Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.paymentcryptography.Key;
 * import com.pulumi.aws.paymentcryptography.KeyArgs;
 * import com.pulumi.aws.paymentcryptography.KeyAlias;
 * import com.pulumi.aws.paymentcryptography.KeyAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Key("test", KeyArgs.builder()
 *             .exportable(true)
 *             .keyAttributes(KeyKeyAttributesArgs.builder()
 *                 .keyAlgorithm("TDES_3KEY")
 *                 .keyClass("SYMMETRIC_KEY")
 *                 .keyUsage("TR31_P0_PIN_ENCRYPTION_KEY")
 *                 .keyModesOfUse(KeyKeyAttributesKeyModesOfUseArgs.builder()
 *                     .decrypt(true)
 *                     .encrypt(true)
 *                     .wrap(true)
 *                     .unwrap(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         var testKeyAlias = new KeyAlias("testKeyAlias", KeyAliasArgs.builder()
 *             .aliasName("alias/test-alias")
 *             .keyArn(test.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:paymentcryptography:Key
 *     properties:
 *       exportable: true
 *       keyAttributes:
 *         - keyAlgorithm: TDES_3KEY
 *           keyClass: SYMMETRIC_KEY
 *           keyUsage: TR31_P0_PIN_ENCRYPTION_KEY
 *           keyModesOfUse:
 *             - decrypt: true
 *               encrypt: true
 *               wrap: true
 *               unwrap: true
 *   testKeyAlias:
 *     type: aws:paymentcryptography:KeyAlias
 *     name: test
 *     properties:
 *       aliasName: alias/test-alias
 *       keyArn: ${test.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:
 * ```sh
 * $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
 * ```
 * @property aliasName Name of the Key Alias.
 * The following arguments are optional:
 * @property keyArn ARN of the key.
 */
public data class KeyAliasArgs(
    public val aliasName: Output<String>? = null,
    public val keyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.paymentcryptography.KeyAliasArgs> {
    override fun toJava(): com.pulumi.aws.paymentcryptography.KeyAliasArgs =
        com.pulumi.aws.paymentcryptography.KeyAliasArgs.builder()
            .aliasName(aliasName?.applyValue({ args0 -> args0 }))
            .keyArn(keyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyAliasArgs].
 */
@PulumiTagMarker
public class KeyAliasArgsBuilder internal constructor() {
    private var aliasName: Output<String>? = null

    private var keyArn: Output<String>? = null

    /**
     * @param value Name of the Key Alias.
     * The following arguments are optional:
     */
    @JvmName("elijtlcyeucwtdol")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value ARN of the key.
     */
    @JvmName("qiphmsgcbhrtymal")
    public suspend fun keyArn(`value`: Output<String>) {
        this.keyArn = value
    }

    /**
     * @param value Name of the Key Alias.
     * The following arguments are optional:
     */
    @JvmName("iphtkdmlhpfkmuhk")
    public suspend fun aliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value ARN of the key.
     */
    @JvmName("txsdcivfdwudualn")
    public suspend fun keyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyArn = mapped
    }

    internal fun build(): KeyAliasArgs = KeyAliasArgs(
        aliasName = aliasName,
        keyArn = keyArn,
    )
}
