@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin

import com.pulumi.aws.paymentcryptography.KeyArgs.builder
import com.pulumi.aws.paymentcryptography.kotlin.inputs.KeyKeyAttributesArgs
import com.pulumi.aws.paymentcryptography.kotlin.inputs.KeyKeyAttributesArgsBuilder
import com.pulumi.aws.paymentcryptography.kotlin.inputs.KeyTimeoutsArgs
import com.pulumi.aws.paymentcryptography.kotlin.inputs.KeyTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Payment Cryptography Control Plane Key.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.paymentcryptography.Key;
 * import com.pulumi.aws.paymentcryptography.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Key("test", KeyArgs.builder()
 *             .exportable(true)
 *             .keyAttributes(KeyKeyAttributesArgs.builder()
 *                 .keyAlgorithm("TDES_3KEY")
 *                 .keyClass("SYMMETRIC_KEY")
 *                 .keyUsage("TR31_P0_PIN_ENCRYPTION_KEY")
 *                 .keyModesOfUse(KeyKeyAttributesKeyModesOfUseArgs.builder()
 *                     .decrypt(true)
 *                     .encrypt(true)
 *                     .wrap(true)
 *                     .unwrap(true)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:paymentcryptography:Key
 *     properties:
 *       exportable: true
 *       keyAttributes:
 *         - keyAlgorithm: TDES_3KEY
 *           keyClass: SYMMETRIC_KEY
 *           keyUsage: TR31_P0_PIN_ENCRYPTION_KEY
 *           keyModesOfUse:
 *             - decrypt: true
 *               encrypt: true
 *               wrap: true
 *               unwrap: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Payment Cryptography Control Plane Key using the `arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf`. For example:
 * ```sh
 * $ pulumi import aws:paymentcryptography/key:Key example arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf
 * ```
 * @property deletionWindowInDays
 * @property enabled Whether to enable the key.
 * @property exportable Whether the key is exportable from the service.
 * @property keyAttributes Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
 * The following arguments are optional:
 * @property keyCheckValueAlgorithm Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
 * @property tags Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class KeyArgs(
    public val deletionWindowInDays: Output<Int>? = null,
    public val enabled: Output<Boolean>? = null,
    public val exportable: Output<Boolean>? = null,
    public val keyAttributes: Output<KeyKeyAttributesArgs>? = null,
    public val keyCheckValueAlgorithm: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<KeyTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.paymentcryptography.KeyArgs> {
    override fun toJava(): com.pulumi.aws.paymentcryptography.KeyArgs =
        com.pulumi.aws.paymentcryptography.KeyArgs.builder()
            .deletionWindowInDays(deletionWindowInDays?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .exportable(exportable?.applyValue({ args0 -> args0 }))
            .keyAttributes(keyAttributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyCheckValueAlgorithm(keyCheckValueAlgorithm?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyArgs].
 */
@PulumiTagMarker
public class KeyArgsBuilder internal constructor() {
    private var deletionWindowInDays: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var exportable: Output<Boolean>? = null

    private var keyAttributes: Output<KeyKeyAttributesArgs>? = null

    private var keyCheckValueAlgorithm: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<KeyTimeoutsArgs>? = null

    /**
     * @param value
     */
    @JvmName("upfefpahwvgthsiq")
    public suspend fun deletionWindowInDays(`value`: Output<Int>) {
        this.deletionWindowInDays = value
    }

    /**
     * @param value Whether to enable the key.
     */
    @JvmName("gyfyubayrwbyryaf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether the key is exportable from the service.
     */
    @JvmName("gjsrkhkilivyxdpc")
    public suspend fun exportable(`value`: Output<Boolean>) {
        this.exportable = value
    }

    /**
     * @param value Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * The following arguments are optional:
     */
    @JvmName("iqhwybmpnqcbdslc")
    public suspend fun keyAttributes(`value`: Output<KeyKeyAttributesArgs>) {
        this.keyAttributes = value
    }

    /**
     * @param value Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     */
    @JvmName("rupovgjxnoohtosh")
    public suspend fun keyCheckValueAlgorithm(`value`: Output<String>) {
        this.keyCheckValueAlgorithm = value
    }

    /**
     * @param value Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nbgeefbuxrbmrhdv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("eijslbdpiclgarib")
    public suspend fun timeouts(`value`: Output<KeyTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value
     */
    @JvmName("pkrugyrqxhsngedu")
    public suspend fun deletionWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionWindowInDays = mapped
    }

    /**
     * @param value Whether to enable the key.
     */
    @JvmName("fxrxwmcphhpjgfxe")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether the key is exportable from the service.
     */
    @JvmName("fiisattckforanyg")
    public suspend fun exportable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportable = mapped
    }

    /**
     * @param value Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * The following arguments are optional:
     */
    @JvmName("umfrmbsldrxjlwma")
    public suspend fun keyAttributes(`value`: KeyKeyAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyAttributes = mapped
    }

    /**
     * @param argument Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * The following arguments are optional:
     */
    @JvmName("gegdrykdtxxwwrek")
    public suspend fun keyAttributes(argument: suspend KeyKeyAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyKeyAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyAttributes = mapped
    }

    /**
     * @param value Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     */
    @JvmName("pfutkblcjaannyay")
    public suspend fun keyCheckValueAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyCheckValueAlgorithm = mapped
    }

    /**
     * @param value Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("djtplqkffmewfumt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqnjxxfgplsgyjek")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ngekceexobykahvs")
    public suspend fun timeouts(`value`: KeyTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nbpecvtullvidphu")
    public suspend fun timeouts(argument: suspend KeyTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = KeyTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): KeyArgs = KeyArgs(
        deletionWindowInDays = deletionWindowInDays,
        enabled = enabled,
        exportable = exportable,
        keyAttributes = keyAttributes,
        keyCheckValueAlgorithm = keyCheckValueAlgorithm,
        tags = tags,
        timeouts = timeouts,
    )
}
