@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin.inputs

import com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property keyAlgorithm Key algorithm to be use during creation of an AWS Payment Cryptography key.
 * @property keyClass Type of AWS Payment Cryptography key to create.
 * @property keyModesOfUse List of cryptographic operations that you can perform using the key.
 * @property keyUsage Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
 */
public data class KeyKeyAttributesArgs(
    public val keyAlgorithm: Output<String>,
    public val keyClass: Output<String>,
    public val keyModesOfUse: Output<KeyKeyAttributesKeyModesOfUseArgs>? = null,
    public val keyUsage: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesArgs> {
    override fun toJava(): com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesArgs =
        com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesArgs.builder()
            .keyAlgorithm(keyAlgorithm.applyValue({ args0 -> args0 }))
            .keyClass(keyClass.applyValue({ args0 -> args0 }))
            .keyModesOfUse(keyModesOfUse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyUsage(keyUsage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyKeyAttributesArgs].
 */
@PulumiTagMarker
public class KeyKeyAttributesArgsBuilder internal constructor() {
    private var keyAlgorithm: Output<String>? = null

    private var keyClass: Output<String>? = null

    private var keyModesOfUse: Output<KeyKeyAttributesKeyModesOfUseArgs>? = null

    private var keyUsage: Output<String>? = null

    /**
     * @param value Key algorithm to be use during creation of an AWS Payment Cryptography key.
     */
    @JvmName("nsrgiymxdvadiure")
    public suspend fun keyAlgorithm(`value`: Output<String>) {
        this.keyAlgorithm = value
    }

    /**
     * @param value Type of AWS Payment Cryptography key to create.
     */
    @JvmName("iufjbejwuyybhlyb")
    public suspend fun keyClass(`value`: Output<String>) {
        this.keyClass = value
    }

    /**
     * @param value List of cryptographic operations that you can perform using the key.
     */
    @JvmName("dmwhmbkqbrdtvahj")
    public suspend fun keyModesOfUse(`value`: Output<KeyKeyAttributesKeyModesOfUseArgs>) {
        this.keyModesOfUse = value
    }

    /**
     * @param value Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
     */
    @JvmName("bgebnbelgdajriql")
    public suspend fun keyUsage(`value`: Output<String>) {
        this.keyUsage = value
    }

    /**
     * @param value Key algorithm to be use during creation of an AWS Payment Cryptography key.
     */
    @JvmName("lcuihnymvaiebwie")
    public suspend fun keyAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyAlgorithm = mapped
    }

    /**
     * @param value Type of AWS Payment Cryptography key to create.
     */
    @JvmName("oetdqaxtrjqifrny")
    public suspend fun keyClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyClass = mapped
    }

    /**
     * @param value List of cryptographic operations that you can perform using the key.
     */
    @JvmName("ouwxyfyaykutyigv")
    public suspend fun keyModesOfUse(`value`: KeyKeyAttributesKeyModesOfUseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyModesOfUse = mapped
    }

    /**
     * @param argument List of cryptographic operations that you can perform using the key.
     */
    @JvmName("wcdeukggdrrqlrgj")
    public suspend fun keyModesOfUse(argument: suspend KeyKeyAttributesKeyModesOfUseArgsBuilder.() -> Unit) {
        val toBeMapped = KeyKeyAttributesKeyModesOfUseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyModesOfUse = mapped
    }

    /**
     * @param value Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
     */
    @JvmName("iyykatjdofkrrnqx")
    public suspend fun keyUsage(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyUsage = mapped
    }

    internal fun build(): KeyKeyAttributesArgs = KeyKeyAttributesArgs(
        keyAlgorithm = keyAlgorithm ?: throw PulumiNullFieldException("keyAlgorithm"),
        keyClass = keyClass ?: throw PulumiNullFieldException("keyClass"),
        keyModesOfUse = keyModesOfUse,
        keyUsage = keyUsage ?: throw PulumiNullFieldException("keyUsage"),
    )
}
