@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin.inputs

import com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesKeyModesOfUseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property decrypt Whether an AWS Payment Cryptography key can be used to decrypt data.
 * @property deriveKey Whether an AWS Payment Cryptography key can be used to derive new keys.
 * @property encrypt Whether an AWS Payment Cryptography key can be used to encrypt data.
 * @property generate Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
 * @property noRestrictions Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
 * @property sign Whether an AWS Payment Cryptography key can be used for signing.
 * @property unwrap Whether an AWS Payment Cryptography key can be used to unwrap other keys.
 * @property verify Whether an AWS Payment Cryptography key can be used to verify signatures.
 * @property wrap Whether an AWS Payment Cryptography key can be used to wrap other keys.
 */
public data class KeyKeyAttributesKeyModesOfUseArgs(
    public val decrypt: Output<Boolean>? = null,
    public val deriveKey: Output<Boolean>? = null,
    public val encrypt: Output<Boolean>? = null,
    public val generate: Output<Boolean>? = null,
    public val noRestrictions: Output<Boolean>? = null,
    public val sign: Output<Boolean>? = null,
    public val unwrap: Output<Boolean>? = null,
    public val verify: Output<Boolean>? = null,
    public val wrap: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesKeyModesOfUseArgs> {
    override fun toJava(): com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesKeyModesOfUseArgs = com.pulumi.aws.paymentcryptography.inputs.KeyKeyAttributesKeyModesOfUseArgs.builder()
        .decrypt(decrypt?.applyValue({ args0 -> args0 }))
        .deriveKey(deriveKey?.applyValue({ args0 -> args0 }))
        .encrypt(encrypt?.applyValue({ args0 -> args0 }))
        .generate(generate?.applyValue({ args0 -> args0 }))
        .noRestrictions(noRestrictions?.applyValue({ args0 -> args0 }))
        .sign(sign?.applyValue({ args0 -> args0 }))
        .unwrap(unwrap?.applyValue({ args0 -> args0 }))
        .verify(verify?.applyValue({ args0 -> args0 }))
        .wrap(wrap?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyKeyAttributesKeyModesOfUseArgs].
 */
@PulumiTagMarker
public class KeyKeyAttributesKeyModesOfUseArgsBuilder internal constructor() {
    private var decrypt: Output<Boolean>? = null

    private var deriveKey: Output<Boolean>? = null

    private var encrypt: Output<Boolean>? = null

    private var generate: Output<Boolean>? = null

    private var noRestrictions: Output<Boolean>? = null

    private var sign: Output<Boolean>? = null

    private var unwrap: Output<Boolean>? = null

    private var verify: Output<Boolean>? = null

    private var wrap: Output<Boolean>? = null

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to decrypt data.
     */
    @JvmName("lkngwracdsgumxhg")
    public suspend fun decrypt(`value`: Output<Boolean>) {
        this.decrypt = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to derive new keys.
     */
    @JvmName("nkdrqtmgguplhiem")
    public suspend fun deriveKey(`value`: Output<Boolean>) {
        this.deriveKey = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to encrypt data.
     */
    @JvmName("tmbbltbavunrmvrh")
    public suspend fun encrypt(`value`: Output<Boolean>) {
        this.encrypt = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
     */
    @JvmName("funhylwhdtfppaad")
    public suspend fun generate(`value`: Output<Boolean>) {
        this.generate = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
     */
    @JvmName("orpbmuwopwncthoh")
    public suspend fun noRestrictions(`value`: Output<Boolean>) {
        this.noRestrictions = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used for signing.
     */
    @JvmName("nnupgvwlsqkpdyed")
    public suspend fun sign(`value`: Output<Boolean>) {
        this.sign = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to unwrap other keys.
     */
    @JvmName("ddaaqylfmknhutbi")
    public suspend fun unwrap(`value`: Output<Boolean>) {
        this.unwrap = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to verify signatures.
     */
    @JvmName("diqwqnabjyhraeov")
    public suspend fun verify(`value`: Output<Boolean>) {
        this.verify = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to wrap other keys.
     */
    @JvmName("mnqagaugoqgxrkvd")
    public suspend fun wrap(`value`: Output<Boolean>) {
        this.wrap = value
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to decrypt data.
     */
    @JvmName("qolyivkeenufabam")
    public suspend fun decrypt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decrypt = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to derive new keys.
     */
    @JvmName("aahhvgvmnfquwnic")
    public suspend fun deriveKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deriveKey = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to encrypt data.
     */
    @JvmName("lrmqbqdlhsnblbpm")
    public suspend fun encrypt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypt = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
     */
    @JvmName("yyskphudywnruimx")
    public suspend fun generate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generate = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
     */
    @JvmName("ixdfeoyuyllllghi")
    public suspend fun noRestrictions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noRestrictions = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used for signing.
     */
    @JvmName("qdraviikwaocjoid")
    public suspend fun sign(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sign = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to unwrap other keys.
     */
    @JvmName("kxktphbgayejhywk")
    public suspend fun unwrap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unwrap = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to verify signatures.
     */
    @JvmName("cvqlteodbwahjiew")
    public suspend fun verify(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verify = mapped
    }

    /**
     * @param value Whether an AWS Payment Cryptography key can be used to wrap other keys.
     */
    @JvmName("jskccrghitwnyswi")
    public suspend fun wrap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wrap = mapped
    }

    internal fun build(): KeyKeyAttributesKeyModesOfUseArgs = KeyKeyAttributesKeyModesOfUseArgs(
        decrypt = decrypt,
        deriveKey = deriveKey,
        encrypt = encrypt,
        generate = generate,
        noRestrictions = noRestrictions,
        sign = sign,
        unwrap = unwrap,
        verify = verify,
        wrap = wrap,
    )
}
