@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyAlgorithm Key algorithm to be use during creation of an AWS Payment Cryptography key.
 * @property keyClass Type of AWS Payment Cryptography key to create.
 * @property keyModesOfUse List of cryptographic operations that you can perform using the key.
 * @property keyUsage Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
 */
public data class KeyKeyAttributes(
    public val keyAlgorithm: String,
    public val keyClass: String,
    public val keyModesOfUse: KeyKeyAttributesKeyModesOfUse? = null,
    public val keyUsage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.paymentcryptography.outputs.KeyKeyAttributes): KeyKeyAttributes = KeyKeyAttributes(
            keyAlgorithm = javaType.keyAlgorithm(),
            keyClass = javaType.keyClass(),
            keyModesOfUse = javaType.keyModesOfUse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.paymentcryptography.kotlin.outputs.KeyKeyAttributesKeyModesOfUse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyUsage = javaType.keyUsage(),
        )
    }
}
