@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.paymentcryptography.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property decrypt Whether an AWS Payment Cryptography key can be used to decrypt data.
 * @property deriveKey Whether an AWS Payment Cryptography key can be used to derive new keys.
 * @property encrypt Whether an AWS Payment Cryptography key can be used to encrypt data.
 * @property generate Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
 * @property noRestrictions Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
 * @property sign Whether an AWS Payment Cryptography key can be used for signing.
 * @property unwrap Whether an AWS Payment Cryptography key can be used to unwrap other keys.
 * @property verify Whether an AWS Payment Cryptography key can be used to verify signatures.
 * @property wrap Whether an AWS Payment Cryptography key can be used to wrap other keys.
 */
public data class KeyKeyAttributesKeyModesOfUse(
    public val decrypt: Boolean? = null,
    public val deriveKey: Boolean? = null,
    public val encrypt: Boolean? = null,
    public val generate: Boolean? = null,
    public val noRestrictions: Boolean? = null,
    public val sign: Boolean? = null,
    public val unwrap: Boolean? = null,
    public val verify: Boolean? = null,
    public val wrap: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.paymentcryptography.outputs.KeyKeyAttributesKeyModesOfUse): KeyKeyAttributesKeyModesOfUse = KeyKeyAttributesKeyModesOfUse(
            decrypt = javaType.decrypt().map({ args0 -> args0 }).orElse(null),
            deriveKey = javaType.deriveKey().map({ args0 -> args0 }).orElse(null),
            encrypt = javaType.encrypt().map({ args0 -> args0 }).orElse(null),
            generate = javaType.generate().map({ args0 -> args0 }).orElse(null),
            noRestrictions = javaType.noRestrictions().map({ args0 -> args0 }).orElse(null),
            sign = javaType.sign().map({ args0 -> args0 }).orElse(null),
            unwrap = javaType.unwrap().map({ args0 -> args0 }).orElse(null),
            verify = javaType.verify().map({ args0 -> args0 }).orElse(null),
            wrap = javaType.wrap().map({ args0 -> args0 }).orElse(null),
        )
    }
}
